/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class WriteToText<@UnknownKeyFor InputT>
extends PTransform<PCollection<InputT>, PDone> {
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("America/Los_Angeles")));
    protected @UnknownKeyFor @NonNull @Initialized String filenamePrefix;
    protected @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldFn<InputT>> fieldFn;
    protected @UnknownKeyFor @NonNull @Initialized boolean windowed;

    public WriteToText() {
    }

    public WriteToText(@UnknownKeyFor @NonNull @Initialized String filenamePrefix, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized FieldFn<InputT>> fieldFn, @UnknownKeyFor @NonNull @Initialized boolean windowed) {
        this.filenamePrefix = filenamePrefix;
        this.fieldFn = fieldFn;
        this.windowed = windowed;
    }

    public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<InputT> teamAndScore) {
        if (this.windowed) {
            ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)new WriteOneFilePerWindow(this.filenamePrefix));
        } else {
            ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)TextIO.write().to(this.filenamePrefix));
        }
        return PDone.in((Pipeline)teamAndScore.getPipeline());
    }

    protected static class PerWindowFiles
    extends FileBasedSink.FilenamePolicy {
        private final @UnknownKeyFor @NonNull @Initialized ResourceId prefix;

        public PerWindowFiles(@UnknownKeyFor @NonNull @Initialized ResourceId prefix) {
            this.prefix = prefix;
        }

        public @UnknownKeyFor @NonNull @Initialized String filenamePrefixForWindow(@UnknownKeyFor @NonNull @Initialized IntervalWindow window) {
            String filePrefix = this.prefix.isDirectory() ? "" : this.prefix.getFilename();
            return String.format("%s-%s-%s", filePrefix, formatter.print((ReadableInstant)window.start()), formatter.print((ReadableInstant)window.end()));
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId windowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized BoundedWindow window, @UnknownKeyFor @NonNull @Initialized PaneInfo paneInfo, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
            IntervalWindow intervalWindow = (IntervalWindow)window;
            String filename = String.format("%s-%s-of-%s%s", this.filenamePrefixForWindow(intervalWindow), shardNumber, numShards, outputFileHints.getSuggestedFilenameSuffix());
            return this.prefix.getCurrentDirectory().resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public @UnknownKeyFor @NonNull @Initialized ResourceId unwindowedFilename(@UnknownKeyFor @NonNull @Initialized int shardNumber, @UnknownKeyFor @NonNull @Initialized int numShards, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileBasedSink.OutputFileHints outputFileHints) {
            throw new UnsupportedOperationException("Unsupported.");
        }
    }

    protected static class WriteOneFilePerWindow
    extends PTransform<PCollection<String>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized String filenamePrefix;

        public WriteOneFilePerWindow(@UnknownKeyFor @NonNull @Initialized String filenamePrefix) {
            this.filenamePrefix = filenamePrefix;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            Preconditions.checkArgument((input.getWindowingStrategy().getWindowFn().windowCoder() == IntervalWindow.getCoder() ? 1 : 0) != 0);
            ResourceId resource = FileBasedSink.convertToFileResourceIfPossible((String)this.filenamePrefix);
            return (PDone)input.apply((PTransform)TextIO.write().to((FileBasedSink.FilenamePolicy)new PerWindowFiles(resource)).withTempDirectory(resource.getCurrentDirectory()).withWindowedWrites().withNumShards(3));
        }
    }

    protected class BuildRowFn
    extends DoFn<InputT, String> {
        protected BuildRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            ArrayList<String> fields = new ArrayList<String>();
            for (Map.Entry entry : WriteToText.this.fieldFn.entrySet()) {
                String key = entry.getKey();
                FieldFn fcn = entry.getValue();
                fields.add(key + ": " + fcn.apply(c, window));
            }
            String result = fields.stream().collect(Collectors.joining(", "));
            c.output((Object)result);
        }
    }

    public static interface FieldFn<@UnknownKeyFor InputT>
    extends Serializable {
        public @UnknownKeyFor @NonNull @Initialized Object apply(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext var1, @UnknownKeyFor @NonNull @Initialized BoundedWindow var2);
    }
}

