/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.kafkatopubsub.transforms;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.beam.examples.complete.kafkatopubsub.avro.AvroDataClass;
import org.apache.beam.examples.complete.kafkatopubsub.avro.AvroDataClassKafkaAvroDeserializer;
import org.apache.beam.examples.complete.kafkatopubsub.kafka.consumer.SslConsumerFactoryFn;
import org.apache.beam.examples.complete.kafkatopubsub.options.KafkaToPubsubOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.extensions.avro.coders.AvroCoder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.kafka.KafkaIO;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Charsets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class FormatTransform {
    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>>> readFromKafka(@UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topicsList, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> kafkaConfig, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> sslConfig) {
        return KafkaIO.read().withBootstrapServers(bootstrapServers).withTopics(topicsList).withKeyDeserializerAndCoder(StringDeserializer.class, (Coder)NullableCoder.of((Coder)StringUtf8Coder.of())).withValueDeserializerAndCoder(StringDeserializer.class, (Coder)NullableCoder.of((Coder)StringUtf8Coder.of())).withConsumerConfigUpdates(kafkaConfig).withConsumerFactoryFn((SerializableFunction)new SslConsumerFactoryFn(sslConfig)).withoutMetadata();
    }

    public static @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PBegin, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized AvroDataClass>>> readAvrosFromKafka(@UnknownKeyFor @NonNull @Initialized String bootstrapServers, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> topicsList, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> config, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> sslConfig) {
        return KafkaIO.read().withBootstrapServers(bootstrapServers).withTopics(topicsList).withKeyDeserializerAndCoder(StringDeserializer.class, (Coder)NullableCoder.of((Coder)StringUtf8Coder.of())).withValueDeserializerAndCoder(AvroDataClassKafkaAvroDeserializer.class, (Coder)AvroCoder.of(AvroDataClass.class)).withConsumerConfigUpdates(config).withConsumerFactoryFn((SerializableFunction)new SslConsumerFactoryFn(sslConfig)).withoutMetadata();
    }

    public static class FormatOutput
    extends PTransform<PCollection<String>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized KafkaToPubsubOptions options;

        public FormatOutput(@UnknownKeyFor @NonNull @Initialized KafkaToPubsubOptions options) {
            this.options = options;
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (PDone)((PCollection)input.apply("convertMessagesToPubsubMessages", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(PubsubMessage.class)).via((SerializableFunction & Serializable)json -> new PubsubMessage(json.getBytes(Charsets.UTF_8), (Map)ImmutableMap.of())))).apply("writePubsubMessagesToPubSub", (PTransform)PubsubIO.writeMessages().to(this.options.getOutputTopic()));
        }
    }

    public static enum FORMAT {
        PUBSUB,
        AVRO;

    }
}

