/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.subprocess.kernel;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.beam.examples.subprocess.configuration.SubProcessConfiguration;
import org.apache.beam.examples.subprocess.kernel.SubProcessCommandLineArgs;
import org.apache.beam.examples.subprocess.kernel.SubProcessIOFiles;
import org.apache.beam.examples.subprocess.utils.CallingSubProcessUtils;
import org.apache.beam.examples.subprocess.utils.FileUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubProcessKernel {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SubProcessKernel.class);
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_SIZE_COMMAND_LINE_ARGS = 131072;
    @UnknownKeyFor @NonNull @Initialized SubProcessConfiguration configuration;
    @UnknownKeyFor @NonNull @Initialized ProcessBuilder processBuilder;

    private SubProcessKernel() {
    }

    public SubProcessKernel(@UnknownKeyFor @NonNull @Initialized SubProcessConfiguration options, @UnknownKeyFor @NonNull @Initialized String binaryName) {
        this.configuration = options;
        this.processBuilder = new ProcessBuilder(binaryName);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> exec(@UnknownKeyFor @NonNull @Initialized SubProcessCommandLineArgs commands) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try (CallingSubProcessUtils.Permit permit = new CallingSubProcessUtils.Permit(this.processBuilder.command().get(0));){
            List<String> results = null;
            try (SubProcessIOFiles outputFiles = new SubProcessIOFiles(this.configuration.getWorkerPath());){
                try {
                    Process process = this.execBinary(this.processBuilder, commands, outputFiles);
                    results = this.collectProcessResults(process, this.processBuilder, outputFiles);
                }
                catch (Exception ex) {
                    LOG.error("Error running executable ", (Throwable)ex);
                    throw ex;
                }
            }
            catch (IOException ex) {
                LOG.error("Unable to delete the outputfiles. This can lead to performance issues and failure", (Throwable)ex);
            }
            List<String> list = results;
            return list;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] execBinaryResult(@UnknownKeyFor @NonNull @Initialized SubProcessCommandLineArgs commands) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Throwable throwable = null;
        try (CallingSubProcessUtils.Permit permit = new CallingSubProcessUtils.Permit(this.processBuilder.command().get(0));){
            byte[] byArray;
            SubProcessIOFiles outputFiles = new SubProcessIOFiles(this.configuration.getWorkerPath());
            Throwable throwable2 = null;
            try {
                Process process = this.execBinary(this.processBuilder, commands, outputFiles);
                byArray = this.collectProcessResultsBytes(process, this.processBuilder, outputFiles);
            }
            catch (Exception ex) {
                try {
                    try {
                        try {
                            try {
                                LOG.error("Error running executable ", (Throwable)ex);
                                throw ex;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            SubProcessKernel.$closeResource(throwable2, outputFiles);
                            throw throwable4;
                        }
                    }
                    catch (IOException ex2) {
                        LOG.error("Unable to delete the outputfiles. This can lead to performance issues and failure", (Throwable)ex2);
                        byte[] byArray2 = new byte[]{};
                        return byArray2;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throw throwable6;
                }
            }
            SubProcessKernel.$closeResource(throwable2, outputFiles);
            return byArray;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized ProcessBuilder prepareBuilder(@UnknownKeyFor @NonNull @Initialized ProcessBuilder builder, @UnknownKeyFor @NonNull @Initialized SubProcessCommandLineArgs commands, @UnknownKeyFor @NonNull @Initialized SubProcessIOFiles outPutFiles) throws @UnknownKeyFor @NonNull @Initialized IllegalStateException {
        if (this.getTotalCommandBytes(commands) > 131072) {
            throw new IllegalStateException("Command is over 2MB in size");
        }
        this.appendExecutablePath(builder);
        builder.command().add(1, outPutFiles.resultFile.toString());
        for (SubProcessCommandLineArgs.Command s : commands.getParameters()) {
            builder.command().add(s.ordinalPosition + 2, s.value);
        }
        builder.redirectError(ProcessBuilder.Redirect.appendTo(outPutFiles.errFile.toFile()));
        builder.redirectOutput(ProcessBuilder.Redirect.appendTo(outPutFiles.outFile.toFile()));
        return builder;
    }

    private @UnknownKeyFor @NonNull @Initialized int getTotalCommandBytes(@UnknownKeyFor @NonNull @Initialized SubProcessCommandLineArgs commands) {
        int size = 0;
        for (SubProcessCommandLineArgs.Command c : commands.getParameters()) {
            size += c.value.length();
        }
        return size;
    }

    private @UnknownKeyFor @NonNull @Initialized Process execBinary(@UnknownKeyFor @NonNull @Initialized ProcessBuilder builder, @UnknownKeyFor @NonNull @Initialized SubProcessCommandLineArgs commands, @UnknownKeyFor @NonNull @Initialized SubProcessIOFiles outPutFiles) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            boolean timeout;
            builder = this.prepareBuilder(builder, commands, outPutFiles);
            Process process = builder.start();
            boolean bl = timeout = !process.waitFor(this.configuration.getWaitTime().intValue(), TimeUnit.SECONDS);
            if (timeout) {
                String log = String.format("Timeout waiting to run process with parameters %s . Check to see if your timeout is long enough. Currently set at %s.", SubProcessKernel.createLogEntryFromInputs(builder.command()), this.configuration.getWaitTime());
                throw new Exception(log);
            }
            return process;
        }
        catch (Exception ex) {
            LOG.error(String.format("Error running process with parameters %s error was %s ", SubProcessKernel.createLogEntryFromInputs(builder.command()), ex.getMessage()));
            throw new Exception(ex);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> collectProcessResults(@UnknownKeyFor @NonNull @Initialized Process process, @UnknownKeyFor @NonNull @Initialized ProcessBuilder builder, @UnknownKeyFor @NonNull @Initialized SubProcessIOFiles outPutFiles) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<String> results = new ArrayList<String>();
        try {
            LOG.debug(String.format("Executing process %s", SubProcessKernel.createLogEntryFromInputs(builder.command())));
            if (process.exitValue() != 0) {
                outPutFiles.copyOutPutFilesToBucket(this.configuration, FileUtils.toStringParams(builder));
                String log = SubProcessKernel.createLogEntryForProcessFailure(process, builder.command(), outPutFiles);
                throw new Exception(log);
            }
            if (!Files.exists(outPutFiles.resultFile, new LinkOption[0])) {
                String log = SubProcessKernel.createLogEntryForProcessFailure(process, builder.command(), outPutFiles);
                outPutFiles.copyOutPutFilesToBucket(this.configuration, FileUtils.toStringParams(builder));
                throw new Exception(log);
            }
            try (Stream<String> lines = Files.lines(outPutFiles.resultFile);){
                for (String line : lines::iterator) {
                    results.add(line);
                }
            }
            return results;
        }
        catch (Exception ex) {
            String log = String.format("Unexpected error runnng process. %s error message was %s", SubProcessKernel.createLogEntryFromInputs(builder.command()), ex.getMessage());
            throw new Exception(log);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] collectProcessResultsBytes(@UnknownKeyFor @NonNull @Initialized Process process, @UnknownKeyFor @NonNull @Initialized ProcessBuilder builder, @UnknownKeyFor @NonNull @Initialized SubProcessIOFiles outPutFiles) throws @UnknownKeyFor @NonNull @Initialized Exception {
        try {
            LOG.debug(String.format("Executing process %s", SubProcessKernel.createLogEntryFromInputs(builder.command())));
            if (process.exitValue() != 0) {
                outPutFiles.copyOutPutFilesToBucket(this.configuration, FileUtils.toStringParams(builder));
                String log = SubProcessKernel.createLogEntryForProcessFailure(process, builder.command(), outPutFiles);
                throw new Exception(log);
            }
            if (!Files.exists(outPutFiles.resultFile, new LinkOption[0])) {
                String log = SubProcessKernel.createLogEntryForProcessFailure(process, builder.command(), outPutFiles);
                outPutFiles.copyOutPutFilesToBucket(this.configuration, FileUtils.toStringParams(builder));
                throw new Exception(log);
            }
            return Files.readAllBytes(outPutFiles.resultFile);
        }
        catch (Exception ex) {
            String log = String.format("Unexpected error runnng process. %s error message was %s", SubProcessKernel.createLogEntryFromInputs(builder.command()), ex.getMessage());
            throw new Exception(log);
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String createLogEntryForProcessFailure(@UnknownKeyFor @NonNull @Initialized Process process, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> commands, @UnknownKeyFor @NonNull @Initialized SubProcessIOFiles files) {
        StringBuilder stringBuilder = new StringBuilder();
        if (process.exitValue() == 0) {
            stringBuilder.append(String.format("%nProcess succeded but no result file was found %n", new Object[0]));
        } else {
            stringBuilder.append(String.format("%nProcess error failed with exit value of %s %n", process.exitValue()));
        }
        stringBuilder.append(String.format("Command info was %s %n", SubProcessKernel.createLogEntryFromInputs(commands)));
        stringBuilder.append(String.format("First line of error file is  %s %n", FileUtils.readLineOfLogFile(files.errFile)));
        stringBuilder.append(String.format("First line of out file is %s %n", FileUtils.readLineOfLogFile(files.outFile)));
        stringBuilder.append(String.format("First line of ret file is %s %n", FileUtils.readLineOfLogFile(files.resultFile)));
        return stringBuilder.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String createLogEntryFromInputs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> commands) {
        String params = commands != null ? String.join((CharSequence)",", commands) : "No-Commands";
        return params;
    }

    private @UnknownKeyFor @NonNull @Initialized ProcessBuilder appendExecutablePath(@UnknownKeyFor @NonNull @Initialized ProcessBuilder builder) {
        String executable = builder.command().get(0);
        if (executable == null) {
            throw new IllegalArgumentException("No executable provided to the Process Builder... we will do... nothing... ");
        }
        builder.command().set(0, FileUtils.getFileResourceId(this.configuration.getWorkerPath(), executable).toString());
        return builder;
    }
}

