/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.FlatMapElements;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

public class MinimalWordCount {
    public static void main(String[] args) {
        PipelineOptions options = PipelineOptionsFactory.create();
        Pipeline p = Pipeline.create((PipelineOptions)options);
        ((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)p.apply((PTransform)TextIO.read().from("gs://apache-beam-samples/shakespeare/*"))).apply((PTransform)FlatMapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)word -> Arrays.asList(word.split("[^\\p{L}]+"))))).apply((PTransform)Filter.by((SerializableFunction & Serializable)word -> !word.isEmpty()))).apply(Count.perElement())).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via((SerializableFunction & Serializable)wordCount -> (String)wordCount.getKey() + ": " + wordCount.getValue()))).apply((PTransform)TextIO.write().to("wordcounts"));
        p.run().waitUntilFinish();
    }
}

