/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.common;

import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_examples_java.com.google.common.base.MoreObjects;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.IntervalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class WriteOneFilePerWindow
extends PTransform<PCollection<String>, PDone> {
    private static final DateTimeFormatter FORMATTER = ISODateTimeFormat.hourMinute();
    private String filenamePrefix;
    @Nullable
    private Integer numShards;

    public WriteOneFilePerWindow(String filenamePrefix, Integer numShards) {
        this.filenamePrefix = filenamePrefix;
        this.numShards = numShards;
    }

    public PDone expand(PCollection<String> input) {
        ResourceId resource = FileBasedSink.convertToFileResourceIfPossible((String)this.filenamePrefix);
        TextIO.Write write = TextIO.write().to((FileBasedSink.FilenamePolicy)new PerWindowFiles(resource)).withTempDirectory(resource.getCurrentDirectory()).withWindowedWrites();
        if (this.numShards != null) {
            write = write.withNumShards(this.numShards.intValue());
        }
        return (PDone)input.apply((PTransform)write);
    }

    public static class PerWindowFiles
    extends FileBasedSink.FilenamePolicy {
        private final ResourceId baseFilename;

        public PerWindowFiles(ResourceId baseFilename) {
            this.baseFilename = baseFilename;
        }

        public String filenamePrefixForWindow(IntervalWindow window) {
            String prefix = this.baseFilename.isDirectory() ? "" : MoreObjects.firstNonNull(this.baseFilename.getFilename(), "");
            return String.format("%s-%s-%s", prefix, FORMATTER.print((ReadableInstant)window.start()), FORMATTER.print((ReadableInstant)window.end()));
        }

        public ResourceId windowedFilename(int shardNumber, int numShards, BoundedWindow window, PaneInfo paneInfo, FileBasedSink.OutputFileHints outputFileHints) {
            IntervalWindow intervalWindow = (IntervalWindow)window;
            String filename = String.format("%s-%s-of-%s%s", this.filenamePrefixForWindow(intervalWindow), shardNumber, numShards, outputFileHints.getSuggestedFilenameSuffix());
            return this.baseFilename.getCurrentDirectory().resolve(filename, (ResolveOptions)ResolveOptions.StandardResolveOptions.RESOLVE_FILE);
        }

        public ResourceId unwindowedFilename(int shardNumber, int numShards, FileBasedSink.OutputFileHints outputFileHints) {
            throw new UnsupportedOperationException("Unsupported.");
        }
    }
}

