/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.complete.game.utils;

import com.google.api.services.bigquery.model.TableRow;
import java.util.Map;
import org.apache.beam.examples.complete.game.utils.WriteToBigQuery;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;

public class WriteWindowedToBigQuery<T>
extends WriteToBigQuery<T> {
    public WriteWindowedToBigQuery(String projectId, String datasetId, String tableName, Map<String, WriteToBigQuery.FieldInfo<T>> fieldInfo) {
        super(projectId, datasetId, tableName, fieldInfo);
    }

    @Override
    public PDone expand(PCollection<T> teamAndScore) {
        ((PCollection)teamAndScore.apply("ConvertToRow", (PTransform)ParDo.of((DoFn)new BuildRowFn()))).apply((PTransform)BigQueryIO.writeTableRows().to(WriteWindowedToBigQuery.getTable(this.projectId, this.datasetId, this.tableName)).withSchema(this.getSchema()).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        return PDone.in((Pipeline)teamAndScore.getPipeline());
    }

    protected class BuildRowFn
    extends DoFn<T, TableRow> {
        protected BuildRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            TableRow row = new TableRow();
            for (Map.Entry entry : WriteWindowedToBigQuery.this.fieldInfo.entrySet()) {
                String key = (String)entry.getKey();
                WriteToBigQuery.FieldInfo fcnInfo = (WriteToBigQuery.FieldInfo)entry.getValue();
                row.set(key, fcnInfo.getFieldFn().apply(c, window));
            }
            c.output((Object)row);
        }
    }
}

