/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.examples.snippets;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.repackaged.beam_examples_java.com.google.common.collect.ImmutableList;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.join.CoGbkResult;
import org.apache.beam.sdk.transforms.join.CoGroupByKey;
import org.apache.beam.sdk.transforms.join.KeyedPCollectionTuple;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;

public class Snippets {
    public static void modelBigQueryIO(Pipeline p) {
        Snippets.modelBigQueryIO(p, "", "", "");
    }

    public static void modelBigQueryIO(Pipeline p, final String writeProject, final String writeDataset, final String writeTable) {
        String string = "clouddataflow-readonly:samples.weather_stations";
        string = "samples.weather_stations";
        string = new TableReference().setProjectId("clouddataflow-readonly").setDatasetId("samples").setTableId("weather_stations");
        String tableSpec = "clouddataflow-readonly:samples.weather_stations";
        PCollection pCollection = (PCollection)((PCollection)p.apply((PTransform)BigQueryIO.readTableRows().from(tableSpec))).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.doubles()).via((SerializableFunction & Serializable)row -> (Double)row.get((Object)"max_temperature")));
        tableSpec = "clouddataflow-readonly:samples.weather_stations";
        pCollection = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).from(tableSpec).withCoder((Coder)DoubleCoder.of()));
        tableSpec = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).fromQuery("SELECT max_temperature FROM [clouddataflow-readonly:samples.weather_stations]").withCoder((Coder)DoubleCoder.of()));
        tableSpec = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> (Double)elem.getRecord().get("max_temperature")).fromQuery("SELECT max_temperature FROM `clouddataflow-readonly.samples.weather_stations`").usingStandardSql().withCoder((Coder)DoubleCoder.of()));
        String tableSchemaJson = "{  \"fields\": [    {      \"name\": \"source\",      \"type\": \"STRING\",      \"mode\": \"NULLABLE\"    },    {      \"name\": \"quote\",      \"type\": \"STRING\",      \"mode\": \"REQUIRED\"    }  ]}";
        String tableSpec2 = "clouddataflow-readonly:samples.weather_stations";
        if (!(writeProject.isEmpty() || writeDataset.isEmpty() || writeTable.isEmpty())) {
            tableSpec2 = writeProject + ":" + writeDataset + "." + writeTable;
        }
        TableSchema tableSchema = new TableSchema().setFields(ImmutableList.of(new TableFieldSchema().setName("source").setType("STRING").setMode("NULLABLE"), new TableFieldSchema().setName("quote").setType("STRING").setMode("REQUIRED")));
        PCollection quotes = (PCollection)p.apply((PTransform)Create.of((Object)new Quote("Mahatma Gandhi", "My life is my message."), (Object[])new Quote[]{new Quote("Yoda", "Do, or do not. There is no 'try'.")}));
        ((PCollection)quotes.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)))).apply((PTransform)BigQueryIO.writeTableRows().to(tableSpec2).withSchema(tableSchema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withSchema(tableSchema).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        quotes.apply((PTransform)BigQueryIO.write().to(tableSpec2).withJsonSchema(tableSchemaJson).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("source", (Object)elem.source).set("quote", (Object)elem.quote)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        PCollection weatherData = (PCollection)p.apply((PTransform)BigQueryIO.read((SerializableFunction & Serializable)elem -> {
            GenericRecord record = elem.getRecord();
            return new WeatherData((Long)record.get("year"), (Long)record.get("month"), (Long)record.get("day"), (Double)record.get("max_temperature"));
        }).fromQuery("SELECT year, month, day, max_temperature FROM [clouddataflow-readonly:samples.weather_stations] WHERE year BETWEEN 2007 AND 2009").withCoder((Coder)AvroCoder.of(WeatherData.class)));
        weatherData.apply((PTransform)BigQueryIO.write().to((DynamicDestinations)new DynamicDestinations<WeatherData, Long>(){

            public Long getDestination(ValueInSingleWindow<WeatherData> elem) {
                return ((WeatherData)elem.getValue()).year;
            }

            public TableDestination getTable(Long destination) {
                return new TableDestination(new TableReference().setProjectId(writeProject).setDatasetId(writeDataset).setTableId(writeTable + "_" + destination), "Table for year " + destination);
            }

            public TableSchema getSchema(Long destination) {
                return new TableSchema().setFields(ImmutableList.of(new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
            }
        }).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("year", (Object)elem.year).set("month", (Object)elem.month).set("day", (Object)elem.day).set("maxTemp", (Object)elem.maxTemp)).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
        String tableSpec3 = "clouddataflow-readonly:samples.weather_stations";
        if (!(writeProject.isEmpty() || writeDataset.isEmpty() || writeTable.isEmpty())) {
            tableSpec3 = writeProject + ":" + writeDataset + "." + writeTable + "_partitioning";
        }
        TableSchema tableSchema2 = new TableSchema().setFields(ImmutableList.of(new TableFieldSchema().setName("year").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("month").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("day").setType("INTEGER").setMode("REQUIRED"), new TableFieldSchema().setName("maxTemp").setType("FLOAT").setMode("NULLABLE")));
        weatherData.apply((PTransform)BigQueryIO.write().to(tableSpec3 + "_partitioning").withSchema(tableSchema2).withFormatFunction((SerializableFunction & Serializable)elem -> new TableRow().set("year", (Object)elem.year).set("month", (Object)elem.month).set("day", (Object)elem.day).set("maxTemp", (Object)elem.maxTemp)).withTimePartitioning(new TimePartitioning().setType("DAY")).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE));
    }

    public static String formatCoGbkResults(String name, Iterable<String> emails, Iterable<String> phones) {
        ArrayList<String> emailsList = new ArrayList<String>();
        for (String elem : emails) {
            emailsList.add("'" + elem + "'");
        }
        Collections.sort(emailsList);
        String emailsStr = "[" + String.join((CharSequence)", ", emailsList) + "]";
        ArrayList<String> phonesList = new ArrayList<String>();
        for (String elem : phones) {
            phonesList.add("'" + elem + "'");
        }
        Collections.sort(phonesList);
        String phonesStr = "[" + String.join((CharSequence)", ", phonesList) + "]";
        return name + "; " + emailsStr + "; " + phonesStr;
    }

    public static PCollection<String> coGroupByKeyTuple(final TupleTag<String> emailsTag, final TupleTag<String> phonesTag, PCollection<KV<String, String>> emails, PCollection<KV<String, String>> phones) {
        PCollection results = (PCollection)KeyedPCollectionTuple.of(emailsTag, emails).and(phonesTag, phones).apply((PTransform)CoGroupByKey.create());
        PCollection contactLines = (PCollection)results.apply((PTransform)ParDo.of((DoFn)new DoFn<KV<String, CoGbkResult>, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) {
                KV e = (KV)c.element();
                String name = (String)e.getKey();
                Iterable emailsIter = ((CoGbkResult)e.getValue()).getAll(emailsTag);
                Iterable phonesIter = ((CoGbkResult)e.getValue()).getAll(phonesTag);
                String formattedResult = Snippets.formatCoGbkResults(name, emailsIter, phonesIter);
                c.output((Object)formattedResult);
            }
        }));
        return contactLines;
    }

    @DefaultCoder(value=AvroCoder.class)
    static class WeatherData {
        final long year;
        final long month;
        final long day;
        final double maxTemp;

        public WeatherData() {
            this.year = 0L;
            this.month = 0L;
            this.day = 0L;
            this.maxTemp = 0.0;
        }

        public WeatherData(long year, long month, long day, double maxTemp) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.maxTemp = maxTemp;
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    static class Quote {
        final String source;
        final String quote;

        public Quote() {
            this.source = "";
            this.quote = "";
        }

        public Quote(String source, String quote) {
            this.source = source;
            this.quote = quote;
        }
    }
}

