/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.python.transforms;

import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.python.PythonExternalTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.PythonCallableSource;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PythonMap<InputT, OutputT>
extends PTransform<PCollection<? extends InputT>, PCollection<OutputT>> {
    private PythonCallableSource pythonFunction;
    private @Nullable String expansionService;
    private Coder<?> outputCoder;
    private static final String PYTHON_MAP_FN_TRANSFORM = "apache_beam.Map";
    private static final String PYTHON_FLATMAP_FN_TRANSFORM = "apache_beam.FlatMap";
    private String pythonTransform;

    private PythonMap(PythonCallableSource pythonFunction, Coder<?> outputCoder, String pythonTransform) {
        this.pythonFunction = pythonFunction;
        this.outputCoder = outputCoder;
        this.pythonTransform = pythonTransform;
    }

    public static <InputT, OutputT> PythonMap<InputT, OutputT> viaMapFn(String pythonFunction, Coder<?> outputCoder) {
        return new PythonMap<InputT, OutputT>(PythonCallableSource.of((String)pythonFunction), outputCoder, PYTHON_MAP_FN_TRANSFORM);
    }

    public static <InputT, OutputT> PythonMap<InputT, OutputT> viaFlatMapFn(String pythonFunction, Coder<?> outputCoder) {
        return new PythonMap<InputT, OutputT>(PythonCallableSource.of((String)pythonFunction), outputCoder, PYTHON_FLATMAP_FN_TRANSFORM);
    }

    public PythonMap<InputT, OutputT> withExpansionService(String expansionService) {
        this.expansionService = expansionService;
        return this;
    }

    public PCollection<OutputT> expand(PCollection<? extends InputT> input) {
        this.expansionService = this.expansionService != null ? this.expansionService : "";
        PythonExternalTransform pythonMapElements = PythonExternalTransform.from(this.pythonTransform, this.expansionService);
        pythonMapElements.withArgs(this.pythonFunction);
        pythonMapElements.withOutputCoder(this.outputCoder);
        return (PCollection)input.apply(pythonMapElements);
    }
}

