/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterJava8Test
implements Serializable {
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={RunnableOnService.class})
    public void testIdentityFilterByPredicate() {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{591, 11789, 1257, 24578, 24799, 307}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> true));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{591, 11789, 1257, 24578, 24799, 307});
        pipeline.run();
    }

    @Test
    public void testNoFilterByPredicate() {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 4, 5}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> false));
        PAssert.that((PCollection)output).empty();
        pipeline.run();
    }

    @Test
    @Category(value={RunnableOnService.class})
    public void testFilterByPredicate() {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> i % 2 == 0));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        pipeline.run();
    }

    @Test
    public void testFilterParDoOutputTypeDescriptorRaw() throws Exception {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new String[]{"hello"}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)s -> true));
        this.thrown.expect(CannotProvideCoderException.class);
        pipeline.getCoderRegistry().getDefaultCoder(output.getTypeDescriptor());
    }

    @Test
    @Category(value={RunnableOnService.class})
    public void testFilterByMethodReference() {
        TestPipeline pipeline = TestPipeline.create();
        PCollection output = (PCollection)((PCollection)pipeline.apply((PTransform)Create.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by(new EvenFilter()::isEven));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        pipeline.run();
    }

    private static class EvenFilter
    implements Serializable {
        private EvenFilter() {
        }

        public boolean isEven(int i) {
            return i % 2 == 0;
        }
    }
}

