/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.RunnableOnService;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Instant;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class WithTimestampsJava8Test
implements Serializable {
    @Test
    @Category(value={RunnableOnService.class})
    public void withTimestampsLambdaShouldApplyTimestamps() {
        TestPipeline p = TestPipeline.create();
        String yearTwoThousand = "946684800000";
        PCollection timestamped = (PCollection)((PCollection)p.apply((PTransform)Create.of((Object[])new String[]{"1234", "0", Integer.toString(Integer.MAX_VALUE), yearTwoThousand}))).apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)input -> new Instant((Object)Long.valueOf(yearTwoThousand))));
        PCollection timestampedVals = (PCollection)timestamped.apply((PTransform)ParDo.of((DoFn)new DoFn<String, KV<String, Instant>>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)KV.of((Object)c.element(), (Object)c.timestamp()));
            }
        }));
        PAssert.that((PCollection)timestamped).containsInAnyOrder((Object[])new String[]{yearTwoThousand, "0", "1234", Integer.toString(Integer.MAX_VALUE)});
        PAssert.that((PCollection)timestampedVals).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"0", (Object)new Instant(0L)), KV.of((Object)"1234", (Object)new Instant((Object)"1234")), KV.of((Object)Integer.toString(Integer.MAX_VALUE), (Object)new Instant(Integer.MAX_VALUE)), KV.of((Object)yearTwoThousand, (Object)new Instant((Object)Long.valueOf(yearTwoThousand)))});
    }
}

