/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdks.java.java8tests.repackaged.com.google.common.collect.Iterables;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CombineJava8Test
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testCombineGloballyLambda() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply((PTransform)Combine.globally((SerializableFunction & Serializable)integers -> {
            int sum = 0;
            Iterator iterator = integers.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sum += i;
            }
            return sum;
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{10});
        this.pipeline.run();
    }

    @Test
    public void testCombineGloballyInstanceMethodReference() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4}))).apply((PTransform)Combine.globally(new Summer()::sum));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{10});
        this.pipeline.run();
    }

    @Test
    public void testCombinePerKeyLambda() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"c", (Object)4)}))).apply((PTransform)Combine.perKey((SerializableFunction & Serializable)integers -> {
            int sum = 0;
            Iterator iterator = integers.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sum += i;
            }
            return sum;
        }));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)4)});
        this.pipeline.run();
    }

    @Test
    public void testCombinePerKeyInstanceMethodReference() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)KV.of((Object)"a", (Object)1), (Object[])new KV[]{KV.of((Object)"b", (Object)2), KV.of((Object)"a", (Object)3), KV.of((Object)"c", (Object)4)}))).apply((PTransform)Combine.perKey(new Summer()::sum));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new KV[]{KV.of((Object)"a", (Object)4), KV.of((Object)"b", (Object)2), KV.of((Object)"c", (Object)4)});
        this.pipeline.run();
    }

    @Test
    public void testLambdaSerialization() {
        boolean lambdaClassSerializationThrows;
        SerializableFunction & Serializable combiner = (SerializableFunction & Serializable)xs -> Iterables.getFirst((Iterable)xs, (Object)0);
        try {
            SerializableUtils.clone(combiner.getClass());
            lambdaClassSerializationThrows = false;
        }
        catch (IllegalArgumentException e) {
            lambdaClassSerializationThrows = true;
        }
        Assume.assumeTrue((String)"Expected lambda class serialization to fail. If it's fixed, we can remove special behavior in Combine.", (boolean)lambdaClassSerializationThrows);
        Combine.Globally combine = Combine.globally((SerializableFunction)combiner);
        SerializableUtils.clone((Serializable)combine);
    }

    @Test
    public void testLambdaDisplayData() {
        Combine.Globally combine = Combine.globally((SerializableFunction & Serializable)xs -> Iterables.getFirst((Iterable)xs, (Object)0));
        DisplayData displayData = DisplayData.from((HasDisplayData)combine);
        MatcherAssert.assertThat((Object)displayData.items(), (Matcher)Matchers.not((Matcher)Matchers.empty()));
    }

    private static class Summer
    implements Serializable {
        private Summer() {
        }

        public int sum(Iterable<Integer> integers) {
            int sum = 0;
            for (int i : integers) {
                sum += i;
            }
            return sum;
        }
    }
}

