/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.Filter;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterJava8Test
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    @Category(value={ValidatesRunner.class})
    public void testIdentityFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)591, (Object[])new Integer[]{11789, 1257, 24578, 24799, 307}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> true));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{591, 11789, 1257, 24578, 24799, 307});
        this.pipeline.run();
    }

    @Test
    public void testNoFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> false));
        PAssert.that((PCollection)output).empty();
        this.pipeline.run();
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFilterByPredicate() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by((SerializableFunction & Serializable)i -> i % 2 == 0));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        this.pipeline.run();
    }

    @Test
    public void testFilterParDoOutputTypeDescriptorRaw() throws Exception {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)Filter.by((SerializableFunction & Serializable)s -> true));
        this.thrown.expect(CannotProvideCoderException.class);
        this.pipeline.getCoderRegistry().getCoder(output.getTypeDescriptor());
    }

    @Test
    @Category(value={ValidatesRunner.class})
    public void testFilterByMethodReference() {
        PCollection output = (PCollection)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 3, 4, 5, 6, 7}))).apply((PTransform)Filter.by(new EvenFilter()::isEven));
        PAssert.that((PCollection)output).containsInAnyOrder((Object[])new Integer[]{2, 4, 6});
        this.pipeline.run();
    }

    private static class EvenFilter
    implements Serializable {
        private EvenFilter() {
        }

        public boolean isEven(int i) {
            return i % 2 == 0;
        }
    }
}

