/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.Serializable;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Partition;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionJava8Test
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();

    @Test
    public void testModPartition() {
        PCollectionList outputs = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)1, (Object[])new Integer[]{2, 4, 5}))).apply((PTransform)Partition.of((int)3, (Partition.PartitionFn & Serializable)(element, numPartitions) -> element % numPartitions));
        Assert.assertEquals((long)3L, (long)outputs.size());
        PAssert.that((PCollection)outputs.get(0)).empty();
        PAssert.that((PCollection)outputs.get(1)).containsInAnyOrder((Object[])new Integer[]{1, 4});
        PAssert.that((PCollection)outputs.get(2)).containsInAnyOrder((Object[])new Integer[]{2, 5});
        this.pipeline.run();
    }

    @Test
    public void testPartitionFnOutputTypeDescriptorRaw() throws Exception {
        PCollectionList output = (PCollectionList)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)"hello", (Object[])new String[0]))).apply((PTransform)Partition.of((int)1, (Partition.PartitionFn & Serializable)(element, numPartitions) -> 0));
        this.thrown.expect(CannotProvideCoderException.class);
        this.pipeline.getCoderRegistry().getCoder(output.get(0).getTypeDescriptor());
    }
}

