/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.iotdb.SSLClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExample {
    private static Logger logger = LoggerFactory.getLogger(HttpExample.class);
    private static final String UTF8 = "utf-8";

    private String getAuthorization(String username, String password) {
        return Base64.getEncoder().encodeToString((username + ":" + password).getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) {
        HttpExample httpExample = new HttpExample();
        httpExample.ping();
        httpExample.insertTablet();
        httpExample.query();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() {
        CloseableHttpClient httpClient = SSLClient.getInstance().getHttpClient();
        HttpGet httpGet = new HttpGet("http://127.0.0.1:18080/ping");
        CloseableHttpResponse response = null;
        try {
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)UTF8);
            String result = JsonParser.parseString((String)message).getAsJsonObject().toString();
            logger.info(result);
        }
        catch (IOException e) {
            logger.error("The ping rest api failed", (Throwable)e);
        }
        finally {
            try {
                httpClient.close();
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Http Client close error", (Throwable)e);
            }
        }
    }

    private HttpPost getHttpPost(String url) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-type", "application/json; charset=utf-8");
        httpPost.setHeader("Accept", "application/json");
        String authorization = this.getAuthorization("root", "root");
        httpPost.setHeader("Authorization", authorization);
        return httpPost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertTablet() {
        CloseableHttpClient httpClient = SSLClient.getInstance().getHttpClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/insertTablet");
            String json = "{\"timestamps\":[1635232143960,1635232153960],\"measurements\":[\"s3\",\"s4\",\"s5\",\"s6\",\"s7\",\"s8\"],\"dataTypes\":[\"TEXT\",\"INT32\",\"INT64\",\"FLOAT\",\"BOOLEAN\",\"DOUBLE\"],\"values\":[[\"2aa\",\"\"],[11,2],[1635000012345555,1635000012345556],[1.41,null],[null,false],[null,3.5555]],\"isAligned\":false,\"deviceId\":\"root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)UTF8);
            String result = JsonParser.parseString((String)message).getAsJsonObject().toString();
            logger.info(result);
        }
        catch (IOException e) {
            logger.error("The insertTablet rest api failed", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Response close error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query() {
        CloseableHttpClient httpClient = SSLClient.getInstance().getHttpClient();
        CloseableHttpResponse response = null;
        try {
            HttpPost httpPost = this.getHttpPost("http://127.0.0.1:18080/rest/v1/query");
            String sql = "{\"sql\":\"select *,s4+1,s4+1 from root.sg25\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(sql, Charset.defaultCharset()));
            response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            String message = EntityUtils.toString((HttpEntity)responseEntity, (String)UTF8);
            ObjectMapper mapper = new ObjectMapper();
            logger.info("message  = {}", mapper.readValue(message, Map.class));
        }
        catch (IOException e) {
            logger.error("The query rest api failed", (Throwable)e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error("Response close error", (Throwable)e);
            }
        }
    }
}

