/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.scripting.java.impl.ServletWrapper;

public final class ServletCache {
    private ConcurrentHashMap<String, ServletWrapper> servlets = new ConcurrentHashMap();

    public ServletWrapper addWrapper(String servletUri, ServletWrapper sw) {
        ServletWrapper previous = this.servlets.putIfAbsent(servletUri, sw);
        if (previous != null) {
            return previous;
        }
        return sw;
    }

    public ServletWrapper getWrapper(String servletUri) {
        return this.servlets.get(servletUri);
    }

    public void removeWrapper(String servletUri) {
        ServletWrapper wrapper = this.servlets.remove(servletUri);
        if (wrapper != null) {
            wrapper.destroy();
        }
    }

    public void destroy() {
        Iterator<ServletWrapper> i = this.servlets.values().iterator();
        while (i.hasNext()) {
            i.next().destroy();
        }
    }
}

