/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.java.impl;

import java.util.Map;
import org.apache.sling.commons.compiler.Options;
import org.apache.sling.commons.osgi.PropertiesUtil;

public class CompilerOptions
extends Options {
    private static final long serialVersionUID = 6526386931840426139L;
    private String encoding;

    public static CompilerOptions createOptions(Map<String, Object> props) {
        String encoding;
        String targetVM;
        String currentVersion = System.getProperty("java.specification.version");
        CompilerOptions opts = new CompilerOptions();
        Boolean classDebugInfo = PropertiesUtil.toBoolean((Object)props.get("java.classdebuginfo"), (boolean)true);
        opts.put("generateDebugInfo", classDebugInfo);
        String sourceVM = PropertiesUtil.toString((Object)props.get("java.compilerSourceVM"), null);
        opts.put("sourceVersion", sourceVM != null && sourceVM.trim().length() > 0 ? sourceVM.trim() : "auto");
        if ("auto".equalsIgnoreCase((String)opts.get("sourceVersion"))) {
            opts.put("sourceVersion", currentVersion);
        }
        opts.put("targetVersion", (targetVM = PropertiesUtil.toString((Object)props.get("java.compilerTargetVM"), null)) != null && targetVM.trim().length() > 0 ? targetVM.trim() : "auto");
        if ("auto".equalsIgnoreCase((String)opts.get("targetVersion"))) {
            opts.put("targetVersion", currentVersion);
        }
        opts.encoding = (encoding = PropertiesUtil.toString((Object)props.get("java.javaEncoding"), null)) != null && encoding.length() > 0 ? encoding : "UTF-8";
        opts.put("ignoreWarnings", true);
        return opts;
    }

    public static CompilerOptions copyOptions(CompilerOptions opt) {
        CompilerOptions opts = new CompilerOptions();
        opts.putAll((Map)((Object)opt));
        opts.encoding = opt.getJavaEncoding();
        return opts;
    }

    public String getJavaEncoding() {
        return this.encoding;
    }
}

