/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.File;
import java.util.Arrays;
import java.util.Properties;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.python.PythonDockerInterpreter;
import org.apache.zeppelin.python.PythonInterpreter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PythonDockerInterpreterTest {
    private PythonDockerInterpreter docker;
    private PythonInterpreter python;

    PythonDockerInterpreterTest() {
    }

    @BeforeEach
    public void setUp() throws InterpreterException {
        this.docker = (PythonDockerInterpreter)Mockito.spy((Object)new PythonDockerInterpreter(new Properties()));
        this.python = (PythonInterpreter)Mockito.mock(PythonInterpreter.class);
        InterpreterGroup group = new InterpreterGroup();
        group.put("note", Arrays.asList(this.python, this.docker));
        this.python.setInterpreterGroup(group);
        this.docker.setInterpreterGroup(group);
        ((PythonDockerInterpreter)Mockito.doReturn((Object)true).when((Object)this.docker)).pull((InterpreterOutput)Matchers.any(InterpreterOutput.class), Matchers.anyString());
        ((PythonInterpreter)Mockito.doReturn((Object)new File("/scriptpath")).when((Object)this.python)).getPythonWorkDir();
        ((PythonDockerInterpreter)Mockito.doReturn((Object)PythonDockerInterpreter.class.getName()).when((Object)this.docker)).getClassName();
        ((PythonInterpreter)Mockito.doReturn((Object)PythonInterpreter.class.getName()).when((Object)this.python)).getClassName();
        this.docker.open();
    }

    @Test
    void testActivateEnv() throws InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        this.docker.interpret("activate env", context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonDockerInterpreter)Mockito.verify((Object)this.docker, (VerificationMode)Mockito.times((int)1))).pull((InterpreterOutput)Matchers.any(InterpreterOutput.class), Matchers.anyString());
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonExec(Mockito.matches((String)"docker run -i --rm -v.*"));
    }

    @Test
    void testDeactivate() throws InterpreterException {
        InterpreterContext context = this.getInterpreterContext();
        this.docker.interpret("deactivate", context);
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).open();
        ((PythonInterpreter)Mockito.verify((Object)this.python, (VerificationMode)Mockito.times((int)1))).close();
        ((PythonInterpreter)Mockito.verify((Object)this.python)).setPythonExec(null);
    }

    private InterpreterContext getInterpreterContext() {
        return InterpreterContext.builder().setInterpreterOut(new InterpreterOutput()).build();
    }
}

