/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.json;

import java.util.ServiceLoader;
import org.apidesign.html.json.impl.ContextAccessor;
import org.apidesign.html.json.spi.ContextBuilder;
import org.apidesign.html.json.spi.ContextProvider;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;

public final class Context {
    private final Technology<?> t;
    private final Transfer r;
    public static final Context EMPTY;

    private Context(Technology<?> t, Transfer r) {
        t.getClass();
        r.getClass();
        this.t = t;
        this.r = r;
    }

    public static Context findDefault(Class<?> requestor) {
        Context c;
        for (ContextProvider cp : ServiceLoader.load(ContextProvider.class)) {
            c = cp.findContext(requestor);
            if (c == null) continue;
            return c;
        }
        for (ContextProvider cp : ServiceLoader.load(ContextProvider.class, ContextProvider.class.getClassLoader())) {
            c = cp.findContext(requestor);
            if (c == null) continue;
            return c;
        }
        return EMPTY;
    }

    static {
        new ContextAccessor(){

            @Override
            protected Context newContext(Technology<?> t, Transfer r) {
                return new Context(t, r);
            }

            @Override
            protected Technology<?> technology(Context c) {
                return c.t;
            }

            @Override
            protected Transfer transfer(Context c) {
                return c.r;
            }
        };
        EMPTY = ContextBuilder.create().build();
    }
}

