/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

public final class JSONCall {
    private final Runnable whenDone;
    private final Object[] result;
    private final String urlBefore;
    private final String urlAfter;

    JSONCall(Runnable whenDone, Object[] result, String urlBefore, String urlAfter) {
        this.whenDone = whenDone;
        this.result = result;
        this.urlBefore = urlBefore;
        this.urlAfter = urlAfter;
    }

    public boolean isJSONP() {
        return this.urlAfter != null;
    }

    public String composeURL(String jsonpCallback) {
        if (this.urlAfter == null != (jsonpCallback == null)) {
            throw new IllegalStateException();
        }
        if (this.urlAfter != null) {
            return this.urlBefore + jsonpCallback + this.urlAfter;
        }
        return this.urlBefore;
    }

    public void notifySuccess(Object result) {
        this.result[0] = result;
        this.whenDone.run();
    }

    public void notifyError(Throwable error) {
        this.result[0] = error;
        this.whenDone.run();
    }
}

