/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import net.java.html.json.Context;
import org.apidesign.html.json.impl.Callback;
import org.apidesign.html.json.impl.ContextAccessor;
import org.apidesign.html.json.impl.PropertyBindingAccessor;
import org.apidesign.html.json.impl.SetAndGet;
import org.apidesign.html.json.spi.FunctionBinding;
import org.apidesign.html.json.spi.PropertyBinding;
import org.apidesign.html.json.spi.Technology;

public final class Bindings<Data> {
    private final Data data;
    private final Technology<Data> bp;

    private Bindings(Data data, Technology<Data> bp) {
        this.data = data;
        this.bp = bp;
    }

    public <M> PropertyBinding registerProperty(String propName, M model, SetAndGet<M> access, boolean readOnly) {
        PropertyBinding pb = PropertyBindingAccessor.create(new PropertyBindingAccessor.PBData<M>(propName, model, access, readOnly));
        this.bp.bind(pb, model, this.data);
        return pb;
    }

    public <M> FunctionBinding registerFunction(String name, M model, Callback<M> access) {
        FunctionBinding fb = PropertyBindingAccessor.createFunction(new PropertyBindingAccessor.FBData<M>(name, model, access));
        this.bp.expose(fb, model, this.data);
        return fb;
    }

    public static Bindings<?> apply(Context c, Object model) {
        Technology<?> bp = ContextAccessor.findTechnology(c);
        return Bindings.apply(bp, model);
    }

    private static <Data> Bindings<Data> apply(Technology<Data> bp, Object model) {
        Data d = bp.wrapModel(model);
        return new Bindings<Data>(d, bp);
    }

    public Data koData() {
        return this.data;
    }

    public void valueHasMutated(String firstName) {
        this.bp.valueHasMutated(this.data, firstName);
    }

    public void applyBindings() {
        this.bp.applyBindings(this.data);
    }

    Object wrapArray(Object[] arr) {
        return this.bp.wrapArray(arr);
    }
}

