/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.java.html.json.Context;
import org.apidesign.html.json.impl.ContextAccessor;
import org.apidesign.html.json.impl.FromJSON;
import org.apidesign.html.json.impl.PropertyBindingAccessor;
import org.apidesign.html.json.spi.JSONCall;
import org.apidesign.html.json.spi.Technology;
import org.apidesign.html.json.spi.Transfer;

public final class JSON {
    private static final Map<Class, FromJSON<?>> froms;

    private JSON() {
    }

    public static void extract(Context c, Object value, String[] props, Object[] values) {
        Transfer t = ContextAccessor.findTransfer(c);
        t.extract(value, props, values);
    }

    private static Object getProperty(Context c, Object obj, String prop) {
        if (prop == null) {
            return obj;
        }
        String[] arr = new String[]{prop};
        Object[] val = new Object[]{null};
        JSON.extract(c, obj, arr, val);
        return val[0];
    }

    public static Object toJSON(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Enum) {
            value = value.toString();
        }
        if (value instanceof String) {
            return '\"' + ((String)value).replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t") + '\"';
        }
        return value.toString();
    }

    public static String toString(Context c, Object obj, String prop) {
        return (obj = JSON.getProperty(c, obj, prop)) instanceof String ? (String)obj : null;
    }

    public static Number toNumber(Context c, Object obj, String prop) {
        if (!((obj = JSON.getProperty(c, obj, prop)) instanceof Number)) {
            obj = Double.NaN;
        }
        return (Number)obj;
    }

    public static <M> M toModel(Context c, Class<M> aClass, Object data, Object object) {
        Technology<?> t = ContextAccessor.findTechnology(c);
        M o = t.toModel(aClass, data);
        return aClass.cast(o);
    }

    public static void loadJSON(Context c, Runnable whenDone, Object[] result, String urlBefore, String urlAfter) {
        JSON.loadJSON(c, whenDone, result, urlBefore, urlAfter, null, null);
    }

    public static void loadJSON(Context c, Runnable whenDone, Object[] result, String urlBefore, String urlAfter, String method, Object data) {
        JSONCall call = PropertyBindingAccessor.createCall(whenDone, result, urlBefore, urlAfter, method, data);
        Transfer t = ContextAccessor.findTransfer(c);
        t.loadJSON(call);
    }

    public static void register(FromJSON<?> from) {
        froms.put(from.factoryFor(), from);
    }

    public static boolean isModel(Class<?> clazz) {
        for (int i = 0; i < 2; ++i) {
            FromJSON<?> from = froms.get(clazz);
            if (from != null) {
                return true;
            }
            JSON.initClass(clazz);
        }
        return false;
    }

    public static <T> T readStream(Context c, Class<T> modelClazz, InputStream data) throws IOException {
        Transfer tr = ContextAccessor.findTransfer(c);
        return JSON.read(c, modelClazz, tr.toJSON(data));
    }

    public static <T> T read(Context c, Class<T> modelClazz, Object data) {
        if (modelClazz == String.class) {
            return modelClazz.cast(data.toString());
        }
        for (int i = 0; i < 2; ++i) {
            FromJSON<?> from = froms.get(modelClazz);
            if (from != null) {
                return modelClazz.cast(from.read(c, data));
            }
            JSON.initClass(modelClazz);
        }
        throw new NullPointerException();
    }

    static void initClass(Class<?> modelClazz) {
        try {
            ClassLoader l;
            try {
                l = modelClazz.getClassLoader();
            }
            catch (SecurityException ex) {
                l = null;
            }
            if (l != null) {
                Class.forName(modelClazz.getName(), true, l);
            }
            modelClazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SecurityException exception) {
            // empty catch block
        }
    }

    static {
        HashMap m = new HashMap();
        froms = m;
    }
}

