/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import net.java.html.json.ComputedProperty;
import net.java.html.json.Function;
import net.java.html.json.Model;
import net.java.html.json.OnPropertyChange;
import net.java.html.json.OnReceive;
import net.java.html.json.Property;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"net.java.html.json.Model", "net.java.html.json.Function", "net.java.html.json.OnReceive", "net.java.html.json.OnPropertyChange", "net.java.html.json.ComputedProperty", "net.java.html.json.Property"})
public final class ModelProcessor
extends AbstractProcessor {
    private static final Logger LOG = Logger.getLogger(ModelProcessor.class.getName());
    private final Map<Element, String> models = new WeakHashMap<Element, String>();
    private final Map<Element, Prprt[]> verify = new WeakHashMap<Element, Prprt[]>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean ok = true;
        for (Element element : roundEnv.getElementsAnnotatedWith(Model.class)) {
            if (this.processModel(element)) continue;
            ok = false;
        }
        if (roundEnv.processingOver()) {
            this.models.clear();
            for (Map.Entry entry : this.verify.entrySet()) {
                Prprt[] props;
                Model m;
                TypeElement te = (TypeElement)entry.getKey();
                String fqn = this.processingEnv.getElementUtils().getBinaryName(te).toString();
                TypeElement finalElem = this.processingEnv.getElementUtils().getTypeElement(fqn);
                if (finalElem == null || (m = finalElem.getAnnotation(Model.class)) == null) continue;
                for (Prprt p : props = Prprt.wrap(this.processingEnv, finalElem, m.properties())) {
                    boolean[] isModel = new boolean[]{false};
                    boolean[] isEnum = new boolean[]{false};
                    boolean[] isPrimitive = new boolean[]{false};
                    String t = this.checkType(p, isModel, isEnum, isPrimitive);
                    if (isEnum[0] || isPrimitive[0] || isModel[0] || "java.lang.String".equals(t)) continue;
                    this.error("The type " + t + " should be defined by @Model annotation", (Element)entry.getKey());
                }
            }
            this.verify.clear();
        }
        return ok;
    }

    private void error(String msg, Element e) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processModel(Element e) {
        boolean ok = true;
        Model m = e.getAnnotation(Model.class);
        if (m == null) {
            return true;
        }
        String pkg = ModelProcessor.findPkgName(e);
        String className = m.className();
        this.models.put(e, className);
        try {
            StringWriter body = new StringWriter();
            ArrayList<String> propsGetSet = new ArrayList<String>();
            ArrayList<String> functions = new ArrayList<String>();
            HashMap<String, Collection<String>> propsDeps = new HashMap<String, Collection<String>>();
            HashMap<String, Collection<String>> functionDeps = new HashMap<String, Collection<String>>();
            Prprt[] props = this.createProps(e, m.properties());
            if (!this.generateComputedProperties(body, props, e.getEnclosedElements(), propsGetSet, propsDeps)) {
                ok = false;
            }
            if (!this.generateOnChange(e, propsDeps, props, className, functionDeps)) {
                ok = false;
            }
            if (!this.generateProperties(e, body, props, propsGetSet, propsDeps, functionDeps)) {
                ok = false;
            }
            if (!this.generateFunctions(e, body, className, e.getEnclosedElements(), functions)) {
                ok = false;
            }
            if (!this.generateReceive(e, body, className, e.getEnclosedElements(), functions)) {
                ok = false;
            }
            JavaFileObject java = this.processingEnv.getFiler().createSourceFile(pkg + '.' + className, e);
            try (OutputStreamWriter w = new OutputStreamWriter(java.openOutputStream());){
                Prprt p;
                int i;
                int i2;
                ((Writer)w).append("package " + pkg + ";\n");
                ((Writer)w).append("import net.java.html.json.*;\n");
                ((Writer)w).append("public final class ").append(className).append(" implements Cloneable {\n");
                ((Writer)w).append("  private boolean locked;\n");
                ((Writer)w).append("  private net.java.html.json.Context context;\n");
                ((Writer)w).append("  private org.apidesign.html.json.impl.Bindings ko;\n");
                ((Writer)w).append(body.toString());
                ((Writer)w).append("  private static Class<" + this.inPckName(e) + "> modelFor() { return null; }\n");
                ((Writer)w).append("  public ").append(className).append("(Context context) {\n");
                ((Writer)w).append("    this.context = context;\n");
                ((Writer)w).append("  };\n");
                ((Writer)w).append("  private org.apidesign.html.json.impl.Bindings intKnckt() {\n");
                ((Writer)w).append("    if (ko != null) return ko;\n");
                ((Writer)w).append("    ko = org.apidesign.html.json.impl.Bindings.apply(context, this);\n");
                for (i2 = 0; i2 < propsGetSet.size(); i2 += 5) {
                    ((Writer)w).append("    ko.registerProperty(\"").append((CharSequence)propsGetSet.get(i2)).append("\", this, new P(");
                    ((Writer)w).append(i2 / 5 + "), " + (propsGetSet.get(i2 + 2) == null) + ");\n");
                }
                for (i2 = 0; i2 < functions.size(); i2 += 2) {
                    ((Writer)w).append("    ko.registerFunction(\"").append((CharSequence)functions.get(i2)).append("\", this, new P(");
                    ((Writer)w).append(i2 / 2 + "));\n");
                }
                ((Writer)w).append("    return ko;\n");
                ((Writer)w).append("  };\n");
                ((Writer)w).append("  private static final class P implements org.apidesign.html.json.impl.SetAndGet<" + className + ">,\n");
                ((Writer)w).append("  org.apidesign.html.json.impl.Callback<" + className + ">,\n");
                ((Writer)w).append("  org.apidesign.html.json.impl.FromJSON<" + className + "> {\n");
                ((Writer)w).append("    private final int type;\n");
                ((Writer)w).append("    P(int t) { type = t; };\n");
                ((Writer)w).append("    public void setValue(" + className + " data, Object value) {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < propsGetSet.size(); i2 += 5) {
                    String btn;
                    String set = (String)propsGetSet.get(i2 + 2);
                    String tn = (String)propsGetSet.get(i2 + 4);
                    if (this.processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_7) < 0 && (btn = ModelProcessor.findBoxedType(tn)) != null) {
                        tn = btn;
                    }
                    if (set == null) continue;
                    ((Writer)w).append("        case " + i2 / 5 + ": data." + ModelProcessor.strip(set) + "((" + tn + ")value); return;\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    public Object getValue(" + className + " data) {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < propsGetSet.size(); i2 += 5) {
                    String get = (String)propsGetSet.get(i2 + 1);
                    if (get == null) continue;
                    ((Writer)w).append("        case " + i2 / 5 + ": return data." + ModelProcessor.strip(get) + "();\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    public void call(" + className + " model, Object data, Object ev) {\n");
                ((Writer)w).append("      switch (type) {\n");
                for (i2 = 0; i2 < functions.size(); i2 += 2) {
                    String name = (String)functions.get(i2);
                    ((Writer)w).append("        case " + i2 / 2 + ": model." + name + "(data, ev); return;\n");
                }
                ((Writer)w).append("      }\n");
                ((Writer)w).append("      throw new UnsupportedOperationException();\n");
                ((Writer)w).append("    }\n");
                ((Writer)w).append("    public Class<" + className + "> factoryFor() { return " + className + ".class; }\n");
                ((Writer)w).append("    public " + className + " read(Context c, Object json) { return new " + className + "(c, json); }\n");
                ((Writer)w).append("  }\n");
                ((Writer)w).append("  static { org.apidesign.html.json.impl.JSON.register(new P(0)); }\n");
                ((Writer)w).append("  private ").append(className).append("(Context c, Object json) {\n");
                ((Writer)w).append("    this.context = c;\n");
                int values = 0;
                for (i = 0; i < propsGetSet.size(); i += 5) {
                    p = ModelProcessor.findPrprt(props, (String)propsGetSet.get(i));
                    if (p == null) continue;
                    ++values;
                }
                ((Writer)w).append("    Object[] ret = new Object[" + values + "];\n");
                ((Writer)w).append("    org.apidesign.html.json.impl.JSON.extract(context, json, new String[] {\n");
                for (i = 0; i < propsGetSet.size(); i += 5) {
                    p = ModelProcessor.findPrprt(props, (String)propsGetSet.get(i));
                    if (p == null) continue;
                    ((Writer)w).append("      \"").append((CharSequence)propsGetSet.get(i)).append("\",\n");
                }
                ((Writer)w).append("    }, ret);\n");
                int cnt = 0;
                int prop = 0;
                for (i = 0; i < propsGetSet.size(); i += 5) {
                    String pn = (String)propsGetSet.get(i);
                    Prprt p2 = ModelProcessor.findPrprt(props, pn);
                    if (p2 == null) continue;
                    boolean[] isModel = new boolean[]{false};
                    boolean[] isEnum = new boolean[]{false};
                    boolean[] isPrimitive = new boolean[]{false};
                    String type = this.checkType(props[prop++], isModel, isEnum, isPrimitive);
                    if (p2.array()) {
                        ((Writer)w).append("    if (ret[" + cnt + "] instanceof Object[]) {\n");
                        ((Writer)w).append("      for (Object e : ((Object[])ret[" + cnt + "])) {\n");
                        if (isModel[0]) {
                            ((Writer)w).append("        this.prop_").append(pn).append(".add(org.apidesign.html.json.impl.JSON.read");
                            ((Writer)w).append("(c, " + type + ".class, e));\n");
                        } else if (isEnum[0]) {
                            ((Writer)w).append("        this.prop_").append(pn);
                            ((Writer)w).append(".add(e == null ? null : ");
                            ((Writer)w).append(type).append(".valueOf((String)e));\n");
                        } else if (this.isPrimitive(type)) {
                            ((Writer)w).append("        this.prop_").append(pn).append(".add(((Number)e).");
                            ((Writer)w).append(type).append("Value());\n");
                        } else {
                            ((Writer)w).append("        this.prop_").append(pn).append(".add((");
                            ((Writer)w).append(type).append(")e);\n");
                        }
                        ((Writer)w).append("      }\n");
                        ((Writer)w).append("    }\n");
                    } else if (isEnum[0]) {
                        ((Writer)w).append("    this.prop_").append(pn);
                        ((Writer)w).append(" = ret[" + cnt + "] == null ? null : ");
                        ((Writer)w).append(type).append(".valueOf((String)ret[" + cnt + "]);\n");
                    } else if (this.isPrimitive(type)) {
                        ((Writer)w).append("    this.prop_").append(pn);
                        ((Writer)w).append(" = ret[" + cnt + "] == null ? (").append(type).append(")0 : ");
                        ((Writer)w).append("((Number)").append("ret[" + cnt + "]).");
                        ((Writer)w).append(type).append("Value();\n");
                    } else {
                        ((Writer)w).append("    this.prop_").append(pn);
                        ((Writer)w).append(" = (").append(type).append(')');
                        ((Writer)w).append("ret[" + cnt + "];\n");
                    }
                    ++cnt;
                }
                ((Writer)w).append("  };\n");
                this.writeToString(props, w);
                this.writeClone(className, props, w);
                w.write("  public " + className + " applyBindings() {\n");
                w.write("    intKnckt().applyBindings();\n");
                w.write("    return this;\n");
                w.write("  }\n");
                w.write("  public boolean equals(Object o) {\n");
                w.write("    if (o == this) return true;\n");
                w.write("    if (o instanceof org.apidesign.html.json.impl.WrapperObject) {\n");
                w.write("      ((org.apidesign.html.json.impl.WrapperObject)o).setRealObject(intKnckt().koData());\n");
                w.write("    }\n");
                w.write("    return false;\n");
                w.write("  }\n");
                w.write("}\n");
            }
        }
        catch (IOException ex) {
            this.error("Can't create " + className + ".java", e);
            return false;
        }
        return ok;
    }

    private boolean generateProperties(Element where, Writer w, Prprt[] properties, Collection<String> props, Map<String, Collection<String>> deps, Map<String, Collection<String>> functionDeps) throws IOException {
        boolean ok = true;
        for (Prprt p : properties) {
            String castTo;
            Collection<String> dependants;
            String tn = this.typeName(where, p);
            String[] gs = ModelProcessor.toGetSet(p.name(), tn, p.array());
            if (p.array()) {
                w.write("  private org.apidesign.html.json.impl.JSONList<" + tn + "> prop_" + p.name() + " = new org.apidesign.html.json.impl.JSONList<" + tn + ">(\"" + p.name() + "\"");
                dependants = deps.get(p.name());
                if (dependants != null) {
                    for (String depProp : dependants) {
                        w.write(", ");
                        w.write(34);
                        w.write(depProp);
                        w.write(34);
                    }
                }
                w.write(")");
                dependants = functionDeps.get(p.name());
                if (dependants != null) {
                    w.write(".onChange(new Runnable() { public void run() {\n");
                    for (String call : dependants) {
                        w.append("  ").append(call);
                    }
                    w.write("  }})");
                }
                w.write(";\n");
                castTo = "java.util.List";
                w.write("  public java.util.List<" + tn + "> " + gs[0] + "() {\n");
                w.write("    if (locked) throw new IllegalStateException();\n");
                w.write("    prop_" + p.name() + ".assign(this.intKnckt());\n");
                w.write("    return prop_" + p.name() + ";\n");
                w.write("  }\n");
            } else {
                castTo = tn;
                w.write("  private " + tn + " prop_" + p.name() + ";\n");
                w.write("  public " + tn + " " + gs[0] + "() {\n");
                w.write("    if (locked) throw new IllegalStateException();\n");
                w.write("    return prop_" + p.name() + ";\n");
                w.write("  }\n");
                w.write("  public void " + gs[1] + "(" + tn + " v) {\n");
                w.write("    if (locked) throw new IllegalStateException();\n");
                w.write("    prop_" + p.name() + " = v;\n");
                w.write("    org.apidesign.html.json.impl.Bindings b = intKnckt();\n");
                w.write("    if (b != null) {\n");
                w.write("      b.valueHasMutated(\"" + p.name() + "\");\n");
                dependants = deps.get(p.name());
                if (dependants != null) {
                    for (String depProp : dependants) {
                        w.write("      b.valueHasMutated(\"" + depProp + "\");\n");
                    }
                }
                w.write("    }\n");
                dependants = functionDeps.get(p.name());
                if (dependants != null) {
                    for (String call : dependants) {
                        w.append("  ").append(call);
                    }
                }
                w.write("  }\n");
            }
            props.add(p.name());
            props.add(gs[2]);
            props.add(gs[3]);
            props.add(gs[0]);
            props.add(castTo);
        }
        return ok;
    }

    /*
     * WARNING - void declaration
     */
    private boolean generateComputedProperties(Writer w, Prprt[] fixedProps, Collection<? extends Element> arr, Collection<String> props, Map<String, Collection<String>> deps) throws IOException {
        boolean ok = true;
        for (Element element : arr) {
            void var19_19;
            if (element.getKind() != ElementKind.METHOD || element.getAnnotation(ComputedProperty.class) == null) continue;
            ExecutableElement ee = (ExecutableElement)element;
            TypeMirror rt = ee.getReturnType();
            Types tu = this.processingEnv.getTypeUtils();
            TypeMirror ert = tu.erasure(rt);
            String tn = this.fqn(ert, ee);
            boolean array = false;
            if (tn.equals("java.util.List")) {
                array = true;
            }
            String sn = ee.getSimpleName().toString();
            String[] gs = ModelProcessor.toGetSet(sn, tn, array);
            w.write("  public " + tn + " " + gs[0] + "() {\n");
            w.write("    if (locked) throw new IllegalStateException();\n");
            int arg = 0;
            for (VariableElement variableElement : ee.getParameters()) {
                String dn;
                if (!this.verifyPropName(variableElement, dn = variableElement.getSimpleName().toString(), fixedProps)) {
                    ok = false;
                }
                String dt = this.fqn(variableElement.asType(), ee);
                String[] call = ModelProcessor.toGetSet(dn, dt, false);
                w.write("    " + dt + " arg" + ++arg + " = ");
                w.write(call[0] + "();\n");
                Collection<String> depends = deps.get(dn);
                if (depends == null) {
                    depends = new LinkedHashSet<String>();
                    deps.put(dn, depends);
                }
                depends.add(sn);
            }
            w.write("    try {\n");
            w.write("      locked = true;\n");
            w.write("      return " + this.fqn(ee.getEnclosingElement().asType(), ee) + '.' + element.getSimpleName() + "(");
            String sep = "";
            boolean bl = true;
            while (var19_19 <= arg) {
                w.write(sep);
                w.write("arg" + (int)var19_19);
                sep = ", ";
                ++var19_19;
            }
            w.write(");\n");
            w.write("    } finally {\n");
            w.write("      locked = false;\n");
            w.write("    }\n");
            w.write("  }\n");
            props.add(element.getSimpleName().toString());
            props.add(gs[2]);
            props.add(null);
            props.add(gs[0]);
            props.add(tn);
        }
        return ok;
    }

    private static String[] toGetSet(String name, String type, boolean array) {
        String n = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String bck2brwsrType = "L" + type.replace('.', '_') + "_2";
        if ("int".equals(type)) {
            bck2brwsrType = "I";
        }
        if ("double".equals(type)) {
            bck2brwsrType = "D";
        }
        String pref = "get";
        if ("boolean".equals(type)) {
            pref = "is";
            bck2brwsrType = "Z";
        }
        String nu = n.replace('.', '_');
        if (array) {
            return new String[]{"get" + n, null, "get" + nu + "__Ljava_util_List_2", null};
        }
        return new String[]{pref + n, "set" + n, pref + nu + "__" + bck2brwsrType, "set" + nu + "__V" + bck2brwsrType};
    }

    private String typeName(Element where, Prprt p) {
        String bt;
        boolean[] isModel = new boolean[]{false};
        boolean[] isEnum = new boolean[]{false};
        boolean[] isPrimitive = new boolean[]{false};
        String ret = this.checkType(p, isModel, isEnum, isPrimitive);
        if (p.array() && (bt = ModelProcessor.findBoxedType(ret)) != null) {
            return bt;
        }
        return ret;
    }

    private static String findBoxedType(String ret) {
        if (ret.equals("boolean")) {
            return Boolean.class.getName();
        }
        if (ret.equals("byte")) {
            return Byte.class.getName();
        }
        if (ret.equals("short")) {
            return Short.class.getName();
        }
        if (ret.equals("char")) {
            return Character.class.getName();
        }
        if (ret.equals("int")) {
            return Integer.class.getName();
        }
        if (ret.equals("long")) {
            return Long.class.getName();
        }
        if (ret.equals("float")) {
            return Float.class.getName();
        }
        if (ret.equals("double")) {
            return Double.class.getName();
        }
        return null;
    }

    private boolean verifyPropName(Element e, String propName, Prprt[] existingProps) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        for (Prprt Prprt2 : existingProps) {
            if (Prprt2.name().equals(propName)) {
                return true;
            }
            sb.append(sep);
            sb.append('\"');
            sb.append(Prprt2.name());
            sb.append('\"');
            sep = ", ";
        }
        this.error(propName + " is not one of known properties: " + sb, e);
        return false;
    }

    private static String findPkgName(Element e) {
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        return ((PackageElement)e).getQualifiedName().toString();
    }

    private boolean generateFunctions(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, List<String> functions) {
        for (Element element : enclosedElements) {
            ExecutableElement e;
            Function onF;
            if (element.getKind() != ElementKind.METHOD || (onF = (e = (ExecutableElement)element).getAnnotation(Function.class)) == null) continue;
            if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnFunction method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnFunction method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnFunction method should return void", e);
                return false;
            }
            String n = e.getSimpleName().toString();
            body.append("  private void ").append(n).append("(Object data, Object ev) {\n");
            body.append("    ").append(clazz.getSimpleName()).append(".").append(n).append("(");
            body.append(this.wrapParams(e, null, className, "ev", "data"));
            body.append(");\n");
            body.append("  }\n");
            functions.add(n);
            functions.add(n + "__VLjava_lang_Object_2Ljava_lang_Object_2");
        }
        return true;
    }

    private boolean generateOnChange(Element clazz, Map<String, Collection<String>> propDeps, Prprt[] properties, String className, Map<String, Collection<String>> functionDeps) {
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement e;
            OnPropertyChange onPC;
            if (element.getKind() != ElementKind.METHOD || (onPC = (e = (ExecutableElement)element).getAnnotation(OnPropertyChange.class)) == null) continue;
            for (String pn : onPC.value()) {
                if (ModelProcessor.findPrprt(properties, pn) != null || !ModelProcessor.findDerivedFrom(propDeps, pn).isEmpty()) continue;
                this.error("No Prprt named '" + pn + "' in the model", clazz);
                return false;
            }
            if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnPrprtChange method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnPrprtChange method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnPrprtChange method should return void", e);
                return false;
            }
            String n = e.getSimpleName().toString();
            for (String pn : onPC.value()) {
                StringBuilder call = new StringBuilder();
                call.append("  ").append(clazz.getSimpleName()).append(".").append(n).append("(");
                call.append(this.wrapPropName(e, className, "name", pn));
                call.append(");\n");
                Collection<String> change = functionDeps.get(pn);
                if (change == null) {
                    change = new ArrayList<String>();
                    functionDeps.put(pn, change);
                }
                change.add(call.toString());
                for (String dpn : ModelProcessor.findDerivedFrom(propDeps, pn)) {
                    change = functionDeps.get(dpn);
                    if (change == null) {
                        change = new ArrayList<String>();
                        functionDeps.put(dpn, change);
                    }
                    change.add(call.toString());
                }
            }
        }
        return true;
    }

    private boolean generateReceive(Element clazz, StringWriter body, String className, List<? extends Element> enclosedElements, List<String> functions) {
        for (Element element : enclosedElements) {
            ExecutableElement e;
            OnReceive onR;
            if (element.getKind() != ElementKind.METHOD || (onR = (e = (ExecutableElement)element).getAnnotation(OnReceive.class)) == null) continue;
            if (!e.getModifiers().contains((Object)Modifier.STATIC)) {
                this.error("@OnReceive method needs to be static", e);
                return false;
            }
            if (e.getModifiers().contains((Object)Modifier.PRIVATE)) {
                this.error("@OnReceive method cannot be private", e);
                return false;
            }
            if (e.getReturnType().getKind() != TypeKind.VOID) {
                this.error("@OnReceive method should return void", e);
                return false;
            }
            if (!onR.jsonp().isEmpty() && !"GET".equals(onR.method())) {
                this.error("JSONP works only with GET transport method", e);
            }
            String dataMirror = this.findDataSpecified(e, onR);
            if ("PUT".equals(onR.method()) && dataMirror == null) {
                this.error("PUT method needs to specify a data() class", e);
                return false;
            }
            if ("POST".equals(onR.method()) && dataMirror == null) {
                this.error("POST method needs to specify a data() class", e);
                return false;
            }
            String modelClass = null;
            boolean expectsList = false;
            ArrayList<String> args = new ArrayList<String>();
            for (VariableElement variableElement : e.getParameters()) {
                TypeMirror modelType = null;
                TypeMirror type = variableElement.asType();
                CharSequence simpleName = type.getKind() == TypeKind.DECLARED ? ((DeclaredType)type).asElement().getSimpleName() : type.toString();
                if (simpleName.toString().equals(className)) {
                    args.add(className + ".this");
                } else if (this.isModel(variableElement.asType())) {
                    modelType = variableElement.asType();
                } else if (variableElement.asType().getKind() == TypeKind.ARRAY) {
                    modelType = ((ArrayType)variableElement.asType()).getComponentType();
                    expectsList = true;
                } else if (variableElement.asType().toString().equals("java.lang.String")) {
                    modelType = variableElement.asType();
                }
                if (modelType == null) continue;
                if (modelClass != null) {
                    this.error("There can be only one model class among arguments", e);
                    continue;
                }
                modelClass = modelType.toString();
                if (expectsList) {
                    args.add("arr");
                    continue;
                }
                args.add("arr[0]");
            }
            if (modelClass == null) {
                this.error("The method needs to have one @Model class as parameter", e);
            }
            String n = e.getSimpleName().toString();
            body.append("  public void ").append(n).append("(");
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder urlAfter = new StringBuilder();
            String jsonpVarName = null;
            String sep = "";
            boolean skipJSONP = onR.jsonp().isEmpty();
            for (String p : this.findParamNames(e, onR.url(), onR.jsonp(), stringBuilder, urlAfter)) {
                if (!skipJSONP && p.equals(onR.jsonp())) {
                    skipJSONP = true;
                    jsonpVarName = p;
                    continue;
                }
                body.append(sep);
                body.append("String ").append(p);
                sep = ", ";
            }
            if (!skipJSONP) {
                this.error("Name of jsonp attribute ('" + onR.jsonp() + "') is not used in url attribute '" + onR.url() + "'", e);
            }
            if (dataMirror != null) {
                body.append(sep).append(dataMirror.toString()).append(" data");
            }
            body.append(") {\n");
            body.append("    final Object[] result = { null };\n");
            body.append("    class ProcessResult implements Runnable {\n      @Override\n      public void run() {\n        Object value = result[0];\n");
            body.append("        " + modelClass + "[] arr;\n");
            body.append("        if (value instanceof Object[]) {\n          Object[] data = ((Object[])value);\n          arr = new " + modelClass + "[data.length];\n" + "          for (int i = 0; i < data.length; i++) {\n" + "            arr[i] = org.apidesign.html.json.impl.JSON.read(context, " + modelClass + ".class, data[i]);\n" + "          }\n" + "        } else {\n" + "          arr = new " + modelClass + "[1];\n" + "          arr[0] = org.apidesign.html.json.impl.JSON.read(context, " + modelClass + ".class, value);\n" + "        }\n");
            body.append("        ").append(clazz.getSimpleName()).append(".").append(n).append("(");
            sep = "";
            for (String arg : args) {
                body.append(sep);
                body.append(arg);
                sep = ", ";
            }
            body.append(");\n");
            body.append("      }\n    }\n");
            body.append("    ProcessResult pr = new ProcessResult();\n");
            body.append("    org.apidesign.html.json.impl.JSON.loadJSON(context, pr, result,\n        ");
            body.append(stringBuilder).append(", ");
            if (jsonpVarName != null) {
                body.append(urlAfter);
            } else {
                body.append("null");
            }
            if (!"GET".equals(onR.method()) || dataMirror != null) {
                body.append(", \"").append(onR.method()).append('\"');
                if (dataMirror != null) {
                    body.append(", data");
                } else {
                    body.append(", null");
                }
            }
            body.append(");\n");
            body.append("  }\n");
        }
        return true;
    }

    private CharSequence wrapParams(ExecutableElement ee, String id, String className, String evName, String dataName) {
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (VariableElement variableElement : ee.getParameters()) {
            if (!first) {
                params.append(", ");
            }
            first = false;
            String toCall = null;
            String toFinish = null;
            if (variableElement.asType() == stringType) {
                if (variableElement.getSimpleName().contentEquals("id")) {
                    params.append('\"').append(id).append('\"');
                    continue;
                }
                toCall = "org.apidesign.html.json.impl.JSON.toString(context, ";
            }
            if (variableElement.asType().getKind() == TypeKind.DOUBLE) {
                toCall = "org.apidesign.html.json.impl.JSON.toNumber(context, ";
                toFinish = ".doubleValue()";
            }
            if (variableElement.asType().getKind() == TypeKind.INT) {
                toCall = "org.apidesign.html.json.impl.JSON.toNumber(context, ";
                toFinish = ".intValue()";
            }
            if (dataName != null && variableElement.getSimpleName().contentEquals(dataName) && this.isModel(variableElement.asType())) {
                toCall = "org.apidesign.html.json.impl.JSON.toModel(context, " + variableElement.asType() + ".class, ";
            }
            if (toCall != null) {
                params.append(toCall);
                if (dataName != null && variableElement.getSimpleName().contentEquals(dataName)) {
                    params.append(dataName);
                    params.append(", null");
                } else {
                    if (evName == null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Unexpected string parameter name.");
                        if (dataName != null) {
                            sb.append(" Try \"").append(dataName).append("\"");
                        }
                        this.error(sb.toString(), ee);
                    }
                    params.append(evName);
                    params.append(", \"");
                    params.append(variableElement.getSimpleName().toString());
                    params.append("\"");
                }
                params.append(")");
                if (toFinish == null) continue;
                params.append(toFinish);
                continue;
            }
            String rn = this.fqn(variableElement.asType(), ee);
            int last = rn.lastIndexOf(46);
            if (last >= 0) {
                rn = rn.substring(last + 1);
            }
            if (rn.equals(className)) {
                params.append(className).append(".this");
                continue;
            }
            this.error("@On method can only accept String named 'id' or " + className + " arguments", ee);
        }
        return params;
    }

    private CharSequence wrapPropName(ExecutableElement ee, String className, String propName, String propValue) {
        TypeMirror stringType = this.processingEnv.getElementUtils().getTypeElement("java.lang.String").asType();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (VariableElement variableElement : ee.getParameters()) {
            if (!first) {
                params.append(", ");
            }
            first = false;
            if (variableElement.asType() == stringType) {
                if (propName != null && variableElement.getSimpleName().contentEquals(propName)) {
                    params.append('\"').append(propValue).append('\"');
                    continue;
                }
                this.error("Unexpected string parameter name. Try \"" + propName + "\".", ee);
                continue;
            }
            String rn = this.fqn(variableElement.asType(), ee);
            int last = rn.lastIndexOf(46);
            if (last >= 0) {
                rn = rn.substring(last + 1);
            }
            if (rn.equals(className)) {
                params.append(className).append(".this");
                continue;
            }
            this.error("@OnPrprtChange method can only accept String or " + className + " arguments", ee);
        }
        return params;
    }

    private boolean isModel(TypeMirror tm) {
        if (tm.getKind() == TypeKind.ERROR) {
            return true;
        }
        Element e = this.processingEnv.getTypeUtils().asElement(tm);
        if (e == null) {
            return false;
        }
        for (Element element : e.getEnclosedElements()) {
            ExecutableElement ee;
            if (element.getKind() != ElementKind.METHOD || !(ee = (ExecutableElement)element).getParameters().isEmpty() || !ee.getSimpleName().contentEquals("modelFor")) continue;
            return true;
        }
        return this.models.values().contains(e.getSimpleName().toString());
    }

    private void writeToString(Prprt[] props, Writer w) throws IOException {
        w.write("  public String toString() {\n");
        w.write("    StringBuilder sb = new StringBuilder();\n");
        w.write("    sb.append('{');\n");
        String sep = "";
        for (Prprt p : props) {
            w.write(sep);
            w.append("    sb.append('\"').append(\"" + p.name() + "\")");
            w.append(".append('\"').append(\":\");\n");
            w.append("    sb.append(org.apidesign.html.json.impl.JSON.toJSON(prop_");
            w.append(p.name()).append("));\n");
            sep = "    sb.append(',');\n";
        }
        w.write("    sb.append('}');\n");
        w.write("    return sb.toString();\n");
        w.write("  }\n");
    }

    private void writeClone(String className, Prprt[] props, Writer w) throws IOException {
        w.write("  public " + className + " clone() {\n");
        w.write("    " + className + " ret = new " + className + "(context);\n");
        for (Prprt p : props) {
            if (!p.array()) {
                boolean[] isModel = new boolean[]{false};
                boolean[] isEnum = new boolean[]{false};
                boolean[] isPrimitive = new boolean[]{false};
                this.checkType(p, isModel, isEnum, isPrimitive);
                if (!isModel[0]) {
                    w.write("    ret.prop_" + p.name() + " = prop_" + p.name() + ";\n");
                    continue;
                }
                w.write("    ret.prop_" + p.name() + " = prop_" + p.name() + ".clone();\n");
                continue;
            }
            w.write("    ret.prop_" + p.name() + " = prop_" + p.name() + ".clone();\n");
        }
        w.write("    return ret;\n");
        w.write("  }\n");
    }

    private String inPckName(Element e) {
        StringBuilder sb = new StringBuilder();
        while (e.getKind() != ElementKind.PACKAGE) {
            if (sb.length() == 0) {
                sb.append(e.getSimpleName());
            } else {
                sb.insert(0, '.');
                sb.insert(0, e.getSimpleName());
            }
            e = e.getEnclosingElement();
        }
        return sb.toString();
    }

    private String fqn(TypeMirror pt, Element relative) {
        if (pt.getKind() == TypeKind.ERROR) {
            Elements eu = this.processingEnv.getElementUtils();
            PackageElement pckg = eu.getPackageOf(relative);
            return pckg.getQualifiedName() + "." + pt.toString();
        }
        return pt.toString();
    }

    private String checkType(Prprt p, boolean[] isModel, boolean[] isEnum, boolean[] isPrimitive) {
        String ret;
        Model m;
        TypeMirror tm;
        try {
            String ret2 = p.typeName(this.processingEnv);
            TypeElement e = this.processingEnv.getElementUtils().getTypeElement(ret2);
            if (e == null) {
                isModel[0] = true;
                isEnum[0] = false;
                isPrimitive[0] = false;
                return ret2;
            }
            tm = e.asType();
        }
        catch (MirroredTypeException ex) {
            tm = ex.getTypeMirror();
        }
        tm = this.processingEnv.getTypeUtils().erasure(tm);
        isPrimitive[0] = tm.getKind().isPrimitive();
        Element e = this.processingEnv.getTypeUtils().asElement(tm);
        Model model = m = e == null ? null : e.getAnnotation(Model.class);
        if (m != null) {
            ret = ModelProcessor.findPkgName(e) + '.' + m.className();
            isModel[0] = true;
            this.models.put(e, m.className());
        } else if (ModelProcessor.findModelForMthd(e)) {
            ret = ((TypeElement)e).getQualifiedName().toString();
            isModel[0] = true;
        } else {
            ret = tm.toString();
        }
        TypeMirror enm = this.processingEnv.getElementUtils().getTypeElement("java.lang.Enum").asType();
        enm = this.processingEnv.getTypeUtils().erasure(enm);
        isEnum[0] = this.processingEnv.getTypeUtils().isSubtype(tm, enm);
        return ret;
    }

    private static boolean findModelForMthd(Element clazz) {
        if (clazz == null) {
            return false;
        }
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement ee;
            if (element.getKind() != ElementKind.METHOD || !(ee = (ExecutableElement)element).getSimpleName().contentEquals("modelFor") || !ee.getParameters().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private Iterable<String> findParamNames(Element e, String url, String jsonParam, StringBuilder ... both) {
        ArrayList<String> params = new ArrayList<String>();
        int wasJSON = 0;
        int pos = 0;
        while (true) {
            int next;
            if ((next = url.indexOf(123, pos)) == -1) {
                both[wasJSON].append('\"').append(url.substring(pos)).append('\"');
                return params;
            }
            int close = url.indexOf(125, next);
            if (close == -1) {
                this.error("Unbalanced '{' and '}' in " + url, e);
                return params;
            }
            String paramName = url.substring(next + 1, close);
            params.add(paramName);
            if (paramName.equals(jsonParam) && !jsonParam.isEmpty()) {
                both[wasJSON].append('\"').append(url.substring(pos, next)).append('\"');
                wasJSON = 1;
            } else {
                both[wasJSON].append('\"').append(url.substring(pos, next)).append("\" + ").append(paramName).append(" + ");
            }
            pos = close + 1;
        }
    }

    private static Prprt findPrprt(Prprt[] properties, String propName) {
        for (Prprt p : properties) {
            if (!propName.equals(p.name())) continue;
            return p;
        }
        return null;
    }

    private boolean isPrimitive(String type) {
        return "int".equals(type) || "double".equals(type) || "long".equals(type) || "short".equals(type) || "byte".equals(type) || "float".equals(type);
    }

    private static Collection<String> findDerivedFrom(Map<String, Collection<String>> propsDeps, String derivedProp) {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry<String, Collection<String>> e : propsDeps.entrySet()) {
            if (!e.getValue().contains(derivedProp)) continue;
            names.add(e.getKey());
        }
        return names;
    }

    private Prprt[] createProps(Element e, Property[] arr) {
        Prprt[] ret = Prprt.wrap(this.processingEnv, e, arr);
        Prprt[] prev = this.verify.put(e, ret);
        if (prev != null) {
            this.error("Two sets of properties for ", e);
        }
        return ret;
    }

    private static String strip(String s) {
        int indx = s.indexOf("__");
        if (indx >= 0) {
            return s.substring(0, indx);
        }
        return s;
    }

    private String findDataSpecified(ExecutableElement e, OnReceive onR) {
        try {
            return onR.data().getName();
        }
        catch (MirroredTypeException ex) {
            String name = ex.getTypeMirror().toString();
            return "java.lang.Object".equals(name) ? null : name;
        }
        catch (Exception ex) {
            AnnotationMirror found = null;
            for (AnnotationMirror annotationMirror : e.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(OnReceive.class.getName())) continue;
                found = annotationMirror;
            }
            if (found == null) {
                return null;
            }
            for (Map.Entry entry : found.getElementValues().entrySet()) {
                ExecutableElement ee = (ExecutableElement)entry.getKey();
                AnnotationValue av = (AnnotationValue)entry.getValue();
                if (!ee.getSimpleName().contentEquals("data")) continue;
                List<? extends Object> values = ModelProcessor.getAnnoValues(this.processingEnv, e, found);
                for (Object object : values) {
                    String sv = object.toString();
                    if (!sv.startsWith("data = ") || !sv.endsWith(".class")) continue;
                    return sv.substring(7, sv.length() - 6);
                }
                return "error";
            }
            return null;
        }
    }

    static List<? extends Object> getAnnoValues(ProcessingEnvironment pe, Element e, AnnotationMirror am) {
        try {
            Class<?> trees = Class.forName("com.sun.tools.javac.api.JavacTrees");
            Method m = trees.getMethod("instance", ProcessingEnvironment.class);
            Object instance = m.invoke(null, pe);
            m = instance.getClass().getMethod("getPath", Element.class, AnnotationMirror.class);
            Object path = m.invoke(instance, e, am);
            m = path.getClass().getMethod("getLeaf", new Class[0]);
            Object leaf = m.invoke(path, new Object[0]);
            m = leaf.getClass().getMethod("getArguments", new Class[0]);
            return (List)m.invoke(leaf, new Object[0]);
        }
        catch (Exception ex) {
            return Collections.emptyList();
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        Level l = Level.FINE;
        LOG.log(l, " element: {0}", element);
        LOG.log(l, " annotation: {0}", annotation);
        LOG.log(l, " member: {0}", member);
        LOG.log(l, " userText: {0}", userText);
        LOG.log(l, "str: {0}", annotation.getAnnotationType().toString());
        if (annotation.getAnnotationType().toString().equals(OnReceive.class.getName()) && member.getSimpleName().contentEquals("method")) {
            return Arrays.asList(ModelProcessor.methodOf("GET"), ModelProcessor.methodOf("POST"), ModelProcessor.methodOf("PUT"), ModelProcessor.methodOf("DELETE"), ModelProcessor.methodOf("HEAD"));
        }
        return super.getCompletions(element, annotation, member, userText);
    }

    private static final Completion methodOf(String method) {
        ResourceBundle rb = ResourceBundle.getBundle("org.apidesign.html.json.impl.Bundle");
        return Completions.of('\"' + method + '\"', rb.getString("MSG_Completion_" + method));
    }

    private static class Prprt {
        private final Element e;
        private final AnnotationMirror tm;
        private final Property p;

        public Prprt(Element e, AnnotationMirror tm, Property p) {
            this.e = e;
            this.tm = tm;
            this.p = p;
        }

        String name() {
            return this.p.name();
        }

        boolean array() {
            return this.p.array();
        }

        String typeName(ProcessingEnvironment env) {
            try {
                return this.p.type().getName();
            }
            catch (AnnotationTypeMismatchException | IncompleteAnnotationException ex) {
                for (Object object : ModelProcessor.getAnnoValues(env, this.e, this.tm)) {
                    String s = object.toString().replace(" ", "");
                    if (!s.startsWith("type=") || !s.endsWith(".class")) continue;
                    return s.substring(5, s.length() - 6);
                }
                throw ex;
            }
        }

        /*
         * WARNING - void declaration
         */
        static Prprt[] wrap(ProcessingEnvironment pe, Element e, Property[] arr) {
            void var6_8;
            if (arr.length == 0) {
                return new Prprt[0];
            }
            if (e.getKind() != ElementKind.CLASS) {
                throw new IllegalStateException("" + (Object)((Object)e.getKind()));
            }
            TypeElement te = (TypeElement)e;
            List val = null;
            block0: for (AnnotationMirror annotationMirror : te.getAnnotationMirrors()) {
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("properties")) continue;
                    val = (List)entry.getValue().getValue();
                    continue block0;
                }
            }
            if (val == null || val.size() != arr.length) {
                pe.getMessager().printMessage(Diagnostic.Kind.ERROR, "" + val, e);
                return new Prprt[0];
            }
            Prprt[] ret = new Prprt[arr.length];
            boolean bl = false;
            while (var6_8 < ret.length) {
                AnnotationMirror am = (AnnotationMirror)((AnnotationValue)val.get((int)var6_8)).getValue();
                ret[var6_8] = new Prprt(e, am, arr[var6_8]);
                ++var6_8;
            }
            return ret;
        }
    }
}

