/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.spi;

import java.io.IOException;
import java.io.OutputStream;

public final class JSONCall {
    private final Runnable whenDone;
    private final Object[] result;
    private final String urlBefore;
    private final String urlAfter;
    private final String method;
    private final Object data;

    JSONCall(Runnable whenDone, Object[] result, String urlBefore, String urlAfter, String method, Object data) {
        this.whenDone = whenDone;
        this.result = result;
        this.urlBefore = urlBefore;
        this.urlAfter = urlAfter;
        this.method = method;
        this.data = data;
    }

    public boolean isDoOutput() {
        return this.data != null;
    }

    public void writeData(OutputStream os) throws IOException {
        if (this.data == null) {
            throw new IOException("No data!");
        }
        os.write(this.data.toString().getBytes("UTF-8"));
        os.flush();
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isJSONP() {
        return this.urlAfter != null;
    }

    public String composeURL(String jsonpCallback) {
        if (this.urlAfter == null != (jsonpCallback == null)) {
            throw new IllegalStateException();
        }
        if (this.urlAfter != null) {
            return this.urlBefore + jsonpCallback + this.urlAfter;
        }
        return this.urlBefore;
    }

    public void notifySuccess(Object result) {
        this.result[0] = result;
        this.whenDone.run();
    }

    public void notifyError(Throwable error) {
        this.result[0] = error;
        this.whenDone.run();
    }
}

