/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apidesign.html.json.impl.Bindings;
import org.apidesign.html.json.impl.JSON;
import org.apidesign.html.json.impl.WrapperObject;

public final class JSONList<T>
extends ArrayList<T> {
    private final String name;
    private final String[] deps;
    private Bindings model;
    private Runnable onchange;

    public JSONList(String name, String ... deps) {
        this.name = name;
        this.deps = deps;
    }

    public void init(T ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        if (this.model != null || !this.isEmpty()) {
            throw new IllegalStateException();
        }
        super.addAll(Arrays.asList(values));
    }

    public void assign(Bindings model) {
        if (this.model == null && this.isEmpty()) {
            this.model = model;
            return;
        }
        if (this.model != model) {
            this.model = model;
            this.notifyChange();
        }
    }

    public JSONList<T> onChange(Runnable r) {
        if (this.onchange != null) {
            throw new IllegalStateException();
        }
        this.onchange = r;
        return this;
    }

    @Override
    public boolean add(T e) {
        boolean ret = super.add(e);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean ret = super.addAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean ret = super.addAll(index, c);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        this.notifyChange();
        return ret;
    }

    @Override
    public void clear() {
        super.clear();
        this.notifyChange();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = super.removeAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean ret = super.retainAll(c);
        this.notifyChange();
        return ret;
    }

    @Override
    public T set(int index, T element) {
        T ret = super.set(index, element);
        this.notifyChange();
        return ret;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        this.notifyChange();
    }

    @Override
    public T remove(int index) {
        Object ret = super.remove(index);
        this.notifyChange();
        return (T)ret;
    }

    @Override
    public String toString() {
        Iterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        String sep = "";
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (it.hasNext()) {
            Object t = it.next();
            sb.append(sep);
            sb.append(JSON.toJSON(t));
            sep = ",";
        }
        sb.append(']');
        return sb.toString();
    }

    private void notifyChange() {
        Bindings m = this.model;
        if (m != null) {
            m.valueHasMutated(this.name);
            for (String dependant : this.deps) {
                m.valueHasMutated(dependant);
            }
            Runnable r = this.onchange;
            if (r != null) {
                r.run();
            }
        }
    }

    @Override
    public JSONList clone() {
        JSONList ko = (JSONList)super.clone();
        ko.model = null;
        return ko;
    }

    static final Object koData(Collection<?> c, Bindings m) {
        Object[] arr = c.toArray();
        for (int i = 0; i < arr.length; ++i) {
            Object r = WrapperObject.find(arr[i], m);
            if (r == null) continue;
            arr[i] = r;
        }
        return m.wrapArray(arr);
    }

    final Object koData() {
        return JSONList.koData(this, this.model);
    }
}

