/*
 * Decompiled with CFR 0.152.
 */
package org.apidesign.html.json.impl;

import net.java.html.BrwsrCtx;
import org.apidesign.html.json.impl.JSON;

public abstract class RcvrJSON {
    protected void onOpen(MsgEvnt msg) {
    }

    protected abstract void onMessage(MsgEvnt var1);

    protected void onClose(MsgEvnt msg) {
    }

    protected abstract void onError(MsgEvnt var1);

    public static abstract class MsgEvnt {
        MsgEvnt() {
        }

        public Throwable getError() {
            return null;
        }

        public final Exception getException() {
            Throwable t = this.getError();
            if (t instanceof Exception) {
                return (Exception)t;
            }
            if (t == null) {
                return null;
            }
            return new Exception(t);
        }

        public int dataSize() {
            return -1;
        }

        public <Data> void dataRead(BrwsrCtx ctx, Class<? extends Data> type, Data[] fillTheArray) {
        }

        public abstract void dispatch(RcvrJSON var1);

        public static MsgEvnt createError(final Throwable t) {
            return new MsgEvnt(){

                @Override
                public Throwable getError() {
                    return t;
                }

                @Override
                public void dispatch(RcvrJSON r) {
                    r.onError(this);
                }
            };
        }

        public static MsgEvnt createMessage(final Object value) {
            return new MsgEvnt(){

                @Override
                public int dataSize() {
                    if (value instanceof Object[]) {
                        return ((Object[])value).length;
                    }
                    return 1;
                }

                @Override
                public <Data> void dataRead(BrwsrCtx context, Class<? extends Data> type, Data[] arr) {
                    if (value instanceof Object[]) {
                        Object[] data = (Object[])value;
                        for (int i = 0; i < data.length && i < arr.length; ++i) {
                            arr[i] = JSON.read(context, type, data[i]);
                        }
                    } else if (arr.length > 0) {
                        arr[0] = JSON.read(context, type, value);
                    }
                }

                @Override
                public void dispatch(RcvrJSON r) {
                    r.onMessage(this);
                }
            };
        }

        public static MsgEvnt createOpen() {
            return new MsgEvnt(){

                @Override
                public void dispatch(RcvrJSON r) {
                    r.onOpen(this);
                }
            };
        }

        public static MsgEvnt createClose() {
            return new MsgEvnt(){

                @Override
                public void dispatch(RcvrJSON r) {
                    r.onClose(this);
                }
            };
        }
    }
}

