/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.processor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.tools.FileObject;
import org.bsc.java2typescript.TSType;
import org.bsc.java2typescript.TypescriptConverter;
import org.bsc.processor.AbstractProcessorEx;

@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"org.bsc.processor.*"})
@SupportedOptions(value={"ts.outfile"})
public class TypescriptProcessor
extends AbstractProcessorEx {
    static final String ENDL = ";\n";
    static final List<TSType> REQUIRED_TYPES = Arrays.asList(TSType.from(String.class, (boolean)true), TSType.from(Iterable.class, (boolean)true), TSType.from(Iterator.class, (boolean)true), TSType.from(Collection.class), TSType.from(Collections.class, (boolean)true), TSType.from(List.class), TSType.from(Set.class), TSType.from(Map.class), TSType.from(Stream.class, (boolean)true), TSType.from(Collectors.class, (boolean)true), TSType.from(Optional.class, (boolean)true));

    private Writer openFile(Path file, String header) throws IOException {
        FileObject out = super.getSourceOutputFile(Paths.get("ts", new String[0]), file);
        this.info("output file [%s]", out.getName());
        Writer w = out.openWriter();
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(header);){
            int c;
            while ((c = is.read()) != -1) {
                w.write(c);
            }
        }
        return w;
    }

    @Override
    public boolean process(AbstractProcessorEx.Context processingContext) throws Exception {
        String targetDefinitionFile = processingContext.getOptionMap().getOrDefault("ts.outfile", "out");
        String definitionsFile = targetDefinitionFile.concat(".d.ts");
        String typesFile = targetDefinitionFile.concat("-types.ts");
        try (Writer wD = this.openFile(Paths.get(definitionsFile, new String[0]), "headerD.ts");
             Writer wT = this.openFile(Paths.get(typesFile, new String[0]), "headerT.ts");){
            Consumer<String> wD_append = s -> {
                try {
                    wD.append((CharSequence)s);
                }
                catch (IOException e) {
                    this.error("error adding [%s]", s);
                }
            };
            Consumer<String> wT_append = s -> {
                try {
                    wT.append((CharSequence)s);
                }
                catch (IOException e) {
                    this.error("error adding [%s]", s);
                }
            };
            Set<TSType> types = this.enumerateDeclaredPackageAndClass(processingContext);
            types.addAll(REQUIRED_TYPES);
            wD.append("//\n").append("// TYPE ALIASES\n").append("//\n\n");
            types.stream().filter(t -> !t.isFunctionalInterface()).filter(t -> t.hasAlias()).map(t -> TypescriptConverter.getAliasDeclaration((Class)t.getValue(), (String)t.getAlias())).forEach(wD_append);
            types.addAll(TypescriptConverter.PREDEFINED_TYPES);
            Map<String, TSType> declaredTypes = types.stream().collect(Collectors.toMap(tt -> tt.getValue().getName(), tt -> tt));
            TypescriptConverter converter = new TypescriptConverter();
            types.stream().filter(tt -> !TypescriptConverter.PREDEFINED_TYPES.contains(tt)).map(tt -> converter.processClass(0, tt, declaredTypes)).forEach(wD_append);
            wT.append("/// <reference path=\"").append(definitionsFile).append("\"/>").append("\n\n");
            types.stream().filter(t -> t.isExport()).map(t -> converter.processStatic(t, declaredTypes)).forEach(wT_append);
        }
        return true;
    }

    private List<? extends AnnotationValue> getAnnotationValueValue(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        AnnotationValue av = entry.getValue();
        return (List)av.getValue();
    }

    private Set<TSType> enumerateDeclaredPackageAndClass(AbstractProcessorEx.Context processingContext) {
        return processingContext.elementFromAnnotations(Optional.empty()).stream().peek(e -> this.info("Anotation [%s]", e.getKind().name())).filter(e -> ElementKind.PACKAGE == e.getKind() || ElementKind.CLASS == e.getKind()).flatMap(e -> e.getAnnotationMirrors().stream()).peek(m -> this.info("Mirror [%s]", m.toString())).flatMap(am -> am.getElementValues().entrySet().stream().filter(entry -> "declare".equals(String.valueOf(((ExecutableElement)entry.getKey()).getSimpleName())))).flatMap(entry -> this.getAnnotationValueValue((Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>)entry).stream()).map(av -> av.getValue()).filter(v -> v instanceof AnnotationMirror).map(v -> (AnnotationMirror)v).map(am -> this.toMapObject((AnnotationMirror)am, () -> TSType.from(Void.class))).collect(Collectors.toSet());
    }
}

