/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.codehaus.modello.ModelloException;
import org.codehaus.modello.ModelloRuntimeException;
import org.codehaus.modello.metadata.Metadata;
import org.codehaus.modello.model.BaseElement;
import org.codehaus.modello.model.CodeSegment;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelDefault;
import org.codehaus.modello.model.ModelField;
import org.codehaus.modello.model.ModelInterface;
import org.codehaus.modello.plugin.java.AbstractJavaModelloGenerator;
import org.codehaus.modello.plugin.java.javasource.JArrayType;
import org.codehaus.modello.plugin.java.javasource.JClass;
import org.codehaus.modello.plugin.java.javasource.JCollectionType;
import org.codehaus.modello.plugin.java.javasource.JConstructor;
import org.codehaus.modello.plugin.java.javasource.JField;
import org.codehaus.modello.plugin.java.javasource.JInterface;
import org.codehaus.modello.plugin.java.javasource.JMethod;
import org.codehaus.modello.plugin.java.javasource.JParameter;
import org.codehaus.modello.plugin.java.javasource.JSourceCode;
import org.codehaus.modello.plugin.java.javasource.JSourceWriter;
import org.codehaus.modello.plugin.java.javasource.JType;
import org.codehaus.modello.plugin.java.metadata.JavaAssociationMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaClassMetadata;
import org.codehaus.modello.plugin.java.metadata.JavaFieldMetadata;
import org.codehaus.modello.plugin.model.ModelClassMetadata;
import org.codehaus.plexus.util.StringUtils;

public class JavaModelloGenerator
extends AbstractJavaModelloGenerator {
    private Collection immutableTypes = new HashSet<String>(Arrays.asList("boolean", "Boolean", "byte", "Byte", "char", "Character", "short", "Short", "int", "Integer", "long", "Long", "float", "Float", "double", "Double", "String"));
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$lang$Cloneable;

    public void generate(Model model, Properties parameters) throws ModelloException {
        this.initialize(model, parameters);
        try {
            this.generateJava();
        }
        catch (IOException ex) {
            throw new ModelloException("Exception while generating Java.", (Throwable)ex);
        }
    }

    private void generateJava() throws ModelloException, IOException {
        Model objectModel = this.getModel();
        Iterator i = objectModel.getInterfaces(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelInterface modelInterface = (ModelInterface)i.next();
            String packageName = modelInterface.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            JSourceWriter sourceWriter = this.newJSourceWriter(packageName, modelInterface.getName());
            JInterface jInterface = new JInterface(packageName + '.' + modelInterface.getName());
            this.initHeader(jInterface);
            this.suppressAllWarnings(objectModel, jInterface);
            if (modelInterface.getSuperInterface() != null) {
                try {
                    ModelInterface superInterface = objectModel.getInterface(modelInterface.getSuperInterface(), this.getGeneratedVersion());
                    String superPackageName = superInterface.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
                    if (!packageName.equals(superPackageName)) {
                        jInterface.addImport(superPackageName + '.' + superInterface.getName());
                    }
                }
                catch (ModelloRuntimeException mre) {
                    // empty catch block
                }
                jInterface.addInterface(modelInterface.getSuperInterface());
            }
            if (modelInterface.getCodeSegments(this.getGeneratedVersion()) != null) {
                Iterator iterator = modelInterface.getCodeSegments(this.getGeneratedVersion()).iterator();
                while (iterator.hasNext()) {
                    CodeSegment codeSegment = (CodeSegment)iterator.next();
                    jInterface.addSourceCode(codeSegment.getCode());
                }
            }
            jInterface.print(sourceWriter);
            sourceWriter.close();
        }
        i = objectModel.getClasses(this.getGeneratedVersion()).iterator();
        while (i.hasNext()) {
            ModelClassMetadata metadata;
            JMethod[] cloneMethods;
            List identifierFields;
            ModelClass modelClass = (ModelClass)i.next();
            JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
            if (!javaClassMetadata.isEnabled()) continue;
            String packageName = modelClass.getPackageName(this.isPackageWithVersion(), this.getGeneratedVersion());
            JSourceWriter sourceWriter = this.newJSourceWriter(packageName, modelClass.getName());
            JClass jClass = new JClass(packageName + '.' + modelClass.getName());
            this.initHeader(jClass);
            this.suppressAllWarnings(objectModel, jClass);
            if (StringUtils.isNotEmpty((String)modelClass.getDescription())) {
                jClass.getJDocComment().setComment(this.appendPeriod(modelClass.getDescription()));
            }
            this.addModelImports(jClass, (BaseElement)modelClass);
            jClass.getModifiers().setAbstract(javaClassMetadata.isAbstract());
            if (modelClass.getSuperClass() != null) {
                jClass.setSuperClass(modelClass.getSuperClass());
            }
            Iterator j = modelClass.getInterfaces().iterator();
            while (j.hasNext()) {
                String implementedInterface = (String)j.next();
                jClass.addInterface(implementedInterface);
            }
            jClass.addInterface((class$java$io$Serializable == null ? JavaModelloGenerator.class$("java.io.Serializable") : class$java$io$Serializable).getName());
            JSourceCode jConstructorSource = new JSourceCode();
            Iterator j2 = modelClass.getFields(this.getGeneratedVersion()).iterator();
            while (j2.hasNext()) {
                ModelField modelField = (ModelField)j2.next();
                if (modelField instanceof ModelAssociation) {
                    this.createAssociation(jClass, (ModelAssociation)modelField, jConstructorSource);
                    continue;
                }
                this.createField(jClass, modelField);
            }
            if (!jConstructorSource.isEmpty()) {
                JConstructor jConstructor = jClass.createConstructor();
                jConstructor.setSourceCode(jConstructorSource);
                jClass.addConstructor(jConstructor);
            }
            if ((identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion())).size() != 0) {
                JMethod equals = this.generateEquals(modelClass);
                jClass.addMethod(equals);
                JMethod hashCode = this.generateHashCode(modelClass);
                jClass.addMethod(hashCode);
                JMethod toString = this.generateToString(modelClass);
                jClass.addMethod(toString);
            }
            if ((cloneMethods = this.generateClone(modelClass)).length > 0) {
                jClass.addInterface((class$java$lang$Cloneable == null ? JavaModelloGenerator.class$("java.lang.Cloneable") : class$java$lang$Cloneable).getName());
                jClass.addMethods(cloneMethods);
            }
            if (modelClass.getCodeSegments(this.getGeneratedVersion()) != null) {
                Iterator iterator = modelClass.getCodeSegments(this.getGeneratedVersion()).iterator();
                while (iterator.hasNext()) {
                    CodeSegment codeSegment = (CodeSegment)iterator.next();
                    jClass.addSourceCode(codeSegment.getCode());
                }
            }
            if ((metadata = (ModelClassMetadata)modelClass.getMetadata(ModelClassMetadata.ID)) != null && metadata.isRootElement()) {
                ModelField modelEncoding = new ModelField(modelClass, "modelEncoding");
                modelEncoding.setType("String");
                modelEncoding.setDefaultValue("UTF-8");
                modelEncoding.addMetadata((Metadata)new JavaFieldMetadata());
                this.createField(jClass, modelEncoding);
            }
            jClass.print(sourceWriter);
            sourceWriter.close();
        }
    }

    private JMethod generateEquals(ModelClass modelClass) {
        JMethod equals = new JMethod("equals", JType.BOOLEAN, null);
        equals.addParameter(new JParameter(new JClass("Object"), "other"));
        JSourceCode sc = equals.getSourceCode();
        sc.add("if ( this == other )");
        sc.add("{");
        sc.addIndented("return true;");
        sc.add("}");
        sc.add("");
        sc.add("if ( !( other instanceof " + modelClass.getName() + " ) )");
        sc.add("{");
        sc.addIndented("return false;");
        sc.add("}");
        sc.add("");
        sc.add(modelClass.getName() + " that = (" + modelClass.getName() + ") other;");
        sc.add("boolean result = true;");
        sc.add("");
        Iterator j = modelClass.getIdentifierFields(this.getGeneratedVersion()).iterator();
        while (j.hasNext()) {
            ModelField identifier = (ModelField)j.next();
            String name = identifier.getName();
            if ("boolean".equals(identifier.getType()) || "byte".equals(identifier.getType()) || "char".equals(identifier.getType()) || "double".equals(identifier.getType()) || "float".equals(identifier.getType()) || "int".equals(identifier.getType()) || "short".equals(identifier.getType()) || "long".equals(identifier.getType())) {
                sc.add("result = result && " + name + " == that." + name + ";");
                continue;
            }
            name = "get" + this.capitalise(name) + "()";
            sc.add("result = result && ( " + name + " == null ? that." + name + " == null : " + name + ".equals( that." + name + " ) );");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("result = result && ( super.equals( other ) );");
        }
        sc.add("");
        sc.add("return result;");
        return equals;
    }

    private JMethod generateToString(ModelClass modelClass) {
        JMethod toString = new JMethod("toString", new JType(String.class.getName()), null);
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        JSourceCode sc = toString.getSourceCode();
        if (identifierFields.size() == 0) {
            sc.add("return super.toString();");
            return toString;
        }
        if (this.useJava5) {
            sc.add("StringBuilder buf = new StringBuilder( 128 );");
        } else {
            sc.add("StringBuffer buf = new StringBuffer( 128 );");
        }
        sc.add("");
        Iterator j = identifierFields.iterator();
        while (j.hasNext()) {
            ModelField identifier = (ModelField)j.next();
            String getter = "boolean".equals(identifier.getType()) ? "is" : "get";
            sc.add("buf.append( \"" + identifier.getName() + " = '\" );");
            sc.add("buf.append( " + getter + this.capitalise(identifier.getName()) + "() );");
            sc.add("buf.append( \"'\" );");
            if (!j.hasNext()) continue;
            sc.add("buf.append( \"\\n\" ); ");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("buf.append( \"\\n\" );");
            sc.add("buf.append( super.toString() );");
        }
        sc.add("");
        sc.add("return buf.toString();");
        return toString;
    }

    private JMethod generateHashCode(ModelClass modelClass) {
        JMethod hashCode = new JMethod("hashCode", JType.INT, null);
        List identifierFields = modelClass.getIdentifierFields(this.getGeneratedVersion());
        JSourceCode sc = hashCode.getSourceCode();
        if (identifierFields.size() == 0) {
            sc.add("return super.hashCode();");
            return hashCode;
        }
        sc.add("int result = 17;");
        sc.add("");
        Iterator j = identifierFields.iterator();
        while (j.hasNext()) {
            ModelField identifier = (ModelField)j.next();
            sc.add("result = 37 * result + " + this.createHashCodeForField(identifier) + ";");
        }
        if (modelClass.getSuperClass() != null) {
            sc.add("result = 37 * result + super.hashCode();");
        }
        sc.add("");
        sc.add("return result;");
        return hashCode;
    }

    private JMethod[] generateClone(ModelClass modelClass) throws ModelloException {
        String cloneModeClass = this.getCloneMode(modelClass);
        if ("none".equals(cloneModeClass)) {
            return new JMethod[0];
        }
        JClass returnType = this.useJava5 ? new JClass(modelClass.getName()) : new JClass("Object");
        JMethod cloneMethod = new JMethod("clone", returnType, null);
        JSourceCode sc = cloneMethod.getSourceCode();
        sc.add("try");
        sc.add("{");
        sc.indent();
        sc.add(modelClass.getName() + " copy = (" + modelClass.getName() + ") super.clone();");
        sc.add("");
        Iterator j = modelClass.getFields(this.getGeneratedVersion()).iterator();
        while (j.hasNext()) {
            boolean deepClone;
            ModelField modelField = (ModelField)j.next();
            String thisField = "this." + modelField.getName();
            String copyField = "copy." + modelField.getName();
            if ("DOM".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = new org.codehaus.plexus.util.xml.Xpp3Dom( (org.codehaus.plexus.util.xml.Xpp3Dom) " + thisField + " );");
                sc.add("}");
                sc.add("");
                continue;
            }
            if ("Date".equalsIgnoreCase(modelField.getType()) || "java.util.Date".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (java.util.Date) " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            if ("java.util.Properties".equals(modelField.getType())) {
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (" + "java.util.Properties" + ") " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            if (!(modelField instanceof ModelAssociation)) continue;
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            String cloneModeAssoc = this.getCloneMode(modelAssociation, cloneModeClass);
            boolean bl = deepClone = "deep".equals(cloneModeAssoc) && !this.immutableTypes.contains(modelAssociation.getTo());
            if (modelAssociation.isOneMultiplicity()) {
                if (!deepClone) continue;
                sc.add("if ( " + thisField + " != null )");
                sc.add("{");
                sc.addIndented(copyField + " = (" + modelAssociation.getTo() + ") " + thisField + ".clone();");
                sc.add("}");
                sc.add("");
                continue;
            }
            sc.add("if ( " + thisField + " != null )");
            sc.add("{");
            sc.indent();
            sc.add(copyField + " = " + this.getDefaultValue(modelAssociation) + ";");
            if (this.isCollection(modelField.getType())) {
                if (deepClone) {
                    if (this.useJava5) {
                        sc.add("for ( " + modelAssociation.getTo() + " item : " + thisField + " )");
                    } else {
                        sc.add("for ( java.util.Iterator it = " + thisField + ".iterator(); it.hasNext(); )");
                    }
                    sc.add("{");
                    sc.indent();
                    if (this.useJava5) {
                        sc.add(copyField + ".add( item.clone() );");
                    } else {
                        sc.add(copyField + ".add( ( (" + modelAssociation.getTo() + ") it.next() ).clone() );");
                    }
                    sc.unindent();
                    sc.add("}");
                } else {
                    sc.add(copyField + ".addAll( " + thisField + " );");
                }
            } else if (this.isMap(modelField.getType())) {
                sc.add(copyField + ".clear();");
                sc.add(copyField + ".putAll( " + thisField + " );");
            }
            sc.unindent();
            sc.add("}");
            sc.add("");
        }
        String cloneHook = this.getCloneHook(modelClass);
        if (StringUtils.isNotEmpty((String)cloneHook) && !"false".equalsIgnoreCase(cloneHook)) {
            if ("true".equalsIgnoreCase(cloneHook)) {
                cloneHook = "cloneHook";
            }
            sc.add(cloneHook + "( copy );");
            sc.add("");
        }
        sc.add("return copy;");
        sc.unindent();
        sc.add("}");
        sc.add("catch ( " + Exception.class.getName() + " ex )");
        sc.add("{");
        sc.indent();
        sc.add("throw (" + RuntimeException.class.getName() + ") new " + UnsupportedOperationException.class.getName() + "( getClass().getName()");
        sc.addIndented("+ \" does not support clone()\" ).initCause( ex );");
        sc.unindent();
        sc.add("}");
        return new JMethod[]{cloneMethod};
    }

    private String getCloneMode(ModelClass modelClass) throws ModelloException {
        String superClass;
        JavaClassMetadata javaClassMetadata;
        String cloneMode = null;
        ModelClass currentClass = modelClass;
        while ((cloneMode = (javaClassMetadata = (JavaClassMetadata)currentClass.getMetadata(JavaClassMetadata.ID)).getCloneMode()) == null && !StringUtils.isEmpty((String)(superClass = currentClass.getSuperClass())) && this.isClassInModel(superClass, this.getModel())) {
            currentClass = this.getModel().getClass(superClass, this.getGeneratedVersion());
        }
        if (cloneMode == null) {
            cloneMode = "none";
        } else if (!JavaClassMetadata.CLONE_MODES.contains(cloneMode)) {
            throw new ModelloException("The Java Modello Generator cannot use '" + cloneMode + "' as a value for <class java.clone=\"...\">, " + "only the following values are acceptable " + JavaClassMetadata.CLONE_MODES);
        }
        return cloneMode;
    }

    private String getCloneMode(ModelAssociation modelAssociation, String cloneModeClass) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        String cloneModeAssoc = javaAssociationMetadata.getCloneMode();
        if (cloneModeAssoc == null) {
            cloneModeAssoc = cloneModeClass;
        } else if (!JavaAssociationMetadata.CLONE_MODES.contains(cloneModeAssoc)) {
            throw new ModelloException("The Java Modello Generator cannot use '" + cloneModeAssoc + "' as a value for <association java.clone=\"...\">, " + "only the following values are acceptable " + JavaAssociationMetadata.CLONE_MODES);
        }
        return cloneModeAssoc;
    }

    private String getCloneHook(ModelClass modelClass) throws ModelloException {
        JavaClassMetadata javaClassMetadata = (JavaClassMetadata)modelClass.getMetadata(JavaClassMetadata.ID);
        return javaClassMetadata.getCloneHook();
    }

    private String appendPeriod(String string) {
        if (string == null) {
            return string;
        }
        String trimmedString = string.trim();
        if (trimmedString.endsWith(".") || trimmedString.endsWith("!") || trimmedString.endsWith("?") || trimmedString.endsWith(">")) {
            return string;
        }
        return string + ".";
    }

    private String createHashCodeForField(ModelField identifier) {
        String name = identifier.getName();
        String type = identifier.getType();
        if ("boolean".equals(type)) {
            return "( " + name + " ? 0 : 1 )";
        }
        if ("byte".equals(type) || "char".equals(type) || "short".equals(type) || "int".equals(type)) {
            return "(int) " + name;
        }
        if ("long".equals(type)) {
            return "(int) ( " + name + " ^ ( " + name + " >>> 32 ) )";
        }
        if ("float".equals(type)) {
            return "Float.floatToIntBits( " + name + " )";
        }
        if ("double".equals(type)) {
            return "(int) ( Double.doubleToLongBits( " + identifier.getName() + " ) ^ ( Double.doubleToLongBits( " + identifier.getName() + " ) >>> 32 ) )";
        }
        return "( " + name + " != null ? " + name + ".hashCode() : 0 )";
    }

    private JField createField(ModelField modelField) throws ModelloException {
        String baseType = modelField.getType();
        if (modelField.isArray()) {
            baseType = baseType.substring(0, baseType.length() - 2);
        }
        JType type = baseType.equals("boolean") ? JType.BOOLEAN : (baseType.equals("byte") ? JType.BYTE : (baseType.equals("char") ? JType.CHAR : (baseType.equals("double") ? JType.DOUBLE : (baseType.equals("float") ? JType.FLOAT : (baseType.equals("int") ? JType.INT : (baseType.equals("short") ? JType.SHORT : (baseType.equals("long") ? JType.LONG : (baseType.equals("Date") ? new JClass("java.util.Date") : (baseType.equals("DOM") ? new JClass("Object") : new JClass(baseType))))))))));
        if (modelField.isArray()) {
            type = new JArrayType(type, this.useJava5);
        }
        JField field = new JField(type, modelField.getName());
        if (modelField.isModelVersionField()) {
            field.setInitString("\"" + this.getGeneratedVersion() + "\"");
        }
        if (modelField.getDefaultValue() != null) {
            field.setInitString(this.getJavaDefaultValue(modelField));
        }
        if (StringUtils.isNotEmpty((String)modelField.getDescription())) {
            field.setComment(this.appendPeriod(modelField.getDescription()));
        }
        return field;
    }

    private void createField(JClass jClass, ModelField modelField) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
        JField field = this.createField(modelField);
        jClass.addField(field);
        if (javaFieldMetadata.isGetter()) {
            jClass.addMethod(this.createGetter(field, modelField));
        }
        if (javaFieldMetadata.isSetter()) {
            jClass.addMethod(this.createSetter(field, modelField));
        }
    }

    private JMethod createGetter(JField field, ModelField modelField) {
        ModelAssociation modelAssociation;
        JavaAssociationMetadata javaAssociationMetadata;
        String propertyName = this.capitalise(field.getName());
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelField.getMetadata(JavaFieldMetadata.ID);
        String prefix = javaFieldMetadata.isBooleanGetter() ? "is" : "get";
        JType returnType = field.getType();
        String interfaceCast = "";
        if (modelField instanceof ModelAssociation && StringUtils.isNotEmpty((String)(javaAssociationMetadata = (JavaAssociationMetadata)(modelAssociation = (ModelAssociation)modelField).getAssociationMetadata(JavaAssociationMetadata.ID)).getInterfaceName()) && !javaFieldMetadata.isBooleanGetter()) {
            returnType = new JClass(javaAssociationMetadata.getInterfaceName());
            interfaceCast = "(" + javaAssociationMetadata.getInterfaceName() + ") ";
        }
        JMethod getter = new JMethod(prefix + propertyName, returnType, null);
        StringBuffer comment = new StringBuffer("Get ");
        if (StringUtils.isEmpty((String)modelField.getDescription())) {
            comment.append("the ");
            comment.append(field.getName());
            comment.append(" field");
        } else {
            comment.append(StringUtils.lowercaseFirstLetter((String)modelField.getDescription().trim()));
        }
        getter.getJDocComment().setComment(this.appendPeriod(comment.toString()));
        getter.getSourceCode().add("return " + interfaceCast + "this." + field.getName() + ";");
        return getter;
    }

    private JMethod createSetter(JField field, ModelField modelField) throws ModelloException {
        String propertyName = this.capitalise(field.getName());
        JMethod setter = new JMethod("set" + propertyName);
        StringBuffer comment = new StringBuffer("Set ");
        if (StringUtils.isEmpty((String)modelField.getDescription())) {
            comment.append("the ");
            comment.append(field.getName());
            comment.append(" field");
        } else {
            comment.append(StringUtils.lowercaseFirstLetter((String)modelField.getDescription().trim()));
        }
        setter.getJDocComment().setComment(this.appendPeriod(comment.toString()));
        JType parameterType = this.getDesiredType(modelField, false);
        setter.addParameter(new JParameter(parameterType, field.getName()));
        JSourceCode sc = setter.getSourceCode();
        if (modelField instanceof ModelAssociation) {
            boolean isOneMultiplicity;
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
            boolean bl = isOneMultiplicity = this.isBidirectionalAssociation(modelAssociation) && modelAssociation.isOneMultiplicity();
            if (isOneMultiplicity && javaAssociationMetadata.isBidi()) {
                sc.add("if ( this." + field.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("this." + field.getName() + ".break" + modelAssociation.getModelClass().getName() + "Association( this );");
                sc.unindent();
                sc.add("}");
                sc.add("");
            }
            String interfaceCast = "";
            if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName()) && modelAssociation.isOneMultiplicity()) {
                interfaceCast = "(" + field.getType().getName() + ") ";
                this.createClassCastAssertion(sc, modelAssociation, "set");
            }
            sc.add("this." + field.getName() + " = " + interfaceCast + field.getName() + ";");
            if (isOneMultiplicity && javaAssociationMetadata.isBidi()) {
                sc.add("");
                sc.add("if ( " + field.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("this." + field.getName() + ".create" + modelAssociation.getModelClass().getName() + "Association( this );");
                sc.unindent();
                sc.add("}");
            }
        } else {
            sc.add("this." + field.getName() + " = " + field.getName() + ";");
        }
        return setter;
    }

    private void createClassCastAssertion(JSourceCode sc, ModelAssociation modelAssociation, String crudModifier) throws ModelloException {
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        if (StringUtils.isEmpty((String)javaAssociationMetadata.getInterfaceName())) {
            return;
        }
        String propertyName = this.capitalise(modelAssociation.getName());
        JField field = this.createField((ModelField)modelAssociation);
        String fieldName = field.getName();
        JClass type = new JClass(modelAssociation.getTo());
        if (modelAssociation.isManyMultiplicity()) {
            fieldName = JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo());
        }
        String instanceName = type.getName();
        sc.add("if ( !( " + fieldName + " instanceof " + instanceName + " ) )");
        sc.add("{");
        sc.indent();
        sc.add("throw new ClassCastException( \"" + modelAssociation.getModelClass().getName() + "." + crudModifier + propertyName + "( " + fieldName + " ) parameter must be instanceof \" + " + instanceName + ".class.getName() );");
        sc.unindent();
        sc.add("}");
    }

    private void createAssociation(JClass jClass, ModelAssociation modelAssociation, JSourceCode jConstructorSource) throws ModelloException {
        JavaFieldMetadata javaFieldMetadata = (JavaFieldMetadata)modelAssociation.getMetadata(JavaFieldMetadata.ID);
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        if (!JavaAssociationMetadata.INIT_TYPES.contains(javaAssociationMetadata.getInitializationMode())) {
            throw new ModelloException("The Java Modello Generator cannot use '" + javaAssociationMetadata.getInitializationMode() + "' as a <association java.init=\"" + javaAssociationMetadata.getInitializationMode() + "\"> " + "value, the only the following are acceptable " + JavaAssociationMetadata.INIT_TYPES);
        }
        if (modelAssociation.isManyMultiplicity()) {
            JType type;
            String defaultValue = this.getDefaultValue(modelAssociation);
            if (modelAssociation.isGenericType()) {
                JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
                type = new JCollectionType(modelAssociation.getType(), componentType, this.useJava5);
                ModelDefault modelDefault = this.getModel().getDefault(modelAssociation.getType());
                defaultValue = this.useJava5 ? StringUtils.replace((String)modelDefault.getValue(), (String)"<?>", (String)("<" + componentType.getName() + ">")) : StringUtils.replace((String)modelDefault.getValue(), (String)"<?>", (String)("/*<" + componentType.getName() + ">*/"));
            } else {
                type = new JClass(modelAssociation.getType());
            }
            JField jField = new JField(type, modelAssociation.getName());
            if (!this.isEmpty(modelAssociation.getComment())) {
                jField.setComment(modelAssociation.getComment());
            }
            if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"field")) {
                jField.setInitString(defaultValue);
            }
            if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"constructor")) {
                jConstructorSource.add("this." + jField.getName() + " = " + defaultValue + ";");
            }
            jClass.addField(jField);
            if (javaFieldMetadata.isGetter()) {
                String propertyName = this.capitalise(jField.getName());
                JMethod getter = new JMethod("get" + propertyName, jField.getType(), null);
                JSourceCode sc = getter.getSourceCode();
                if (StringUtils.equals((String)javaAssociationMetadata.getInitializationMode(), (String)"lazy")) {
                    sc.add("if ( this." + jField.getName() + " == null )");
                    sc.add("{");
                    sc.indent();
                    sc.add("this." + jField.getName() + " = " + defaultValue + ";");
                    sc.unindent();
                    sc.add("}");
                    sc.add("");
                }
                sc.add("return this." + jField.getName() + ";");
                jClass.addMethod(getter);
            }
            if (javaFieldMetadata.isSetter()) {
                jClass.addMethod(this.createSetter(jField, (ModelField)modelAssociation));
            }
            if (javaAssociationMetadata.isAdder()) {
                this.createAdder(modelAssociation, jClass);
            }
        } else {
            this.createField(jClass, (ModelField)modelAssociation);
        }
        if (this.isBidirectionalAssociation(modelAssociation)) {
            if (javaAssociationMetadata.isBidi()) {
                this.createCreateAssociation(jClass, modelAssociation);
            }
            if (javaAssociationMetadata.isBidi()) {
                this.createBreakAssociation(jClass, modelAssociation);
            }
        }
    }

    private JType getComponentType(ModelAssociation modelAssociation, JavaAssociationMetadata javaAssociationMetadata) {
        JClass componentType = javaAssociationMetadata.getInterfaceName() != null ? new JClass(javaAssociationMetadata.getInterfaceName()) : new JClass(modelAssociation.getTo());
        return componentType;
    }

    private void createCreateAssociation(JClass jClass, ModelAssociation modelAssociation) {
        JMethod createMethod = new JMethod("create" + modelAssociation.getTo() + "Association");
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        createMethod.addParameter(new JParameter(new JClass(modelAssociation.getTo()), JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo())));
        JSourceCode sc = createMethod.getSourceCode();
        if (modelAssociation.isOneMultiplicity()) {
            if (javaAssociationMetadata.isBidi()) {
                sc.add("if ( this." + modelAssociation.getName() + " != null )");
                sc.add("{");
                sc.indent();
                sc.add("break" + modelAssociation.getTo() + "Association( this." + modelAssociation.getName() + " );");
                sc.unindent();
                sc.add("}");
                sc.add("");
            }
            sc.add("this." + modelAssociation.getName() + " = " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + ";");
        } else {
            jClass.addImport("java.util.Collection");
            sc.add("Collection " + modelAssociation.getName() + " = get" + this.capitalise(modelAssociation.getName()) + "();");
            sc.add("");
            sc.add("if ( " + modelAssociation.getName() + ".contains( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " ) )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " is already assigned.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add(modelAssociation.getName() + ".add( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " );");
        }
        jClass.addMethod(createMethod);
    }

    private void createBreakAssociation(JClass jClass, ModelAssociation modelAssociation) {
        JMethod breakMethod = new JMethod("break" + modelAssociation.getTo() + "Association");
        breakMethod.addParameter(new JParameter(new JClass(modelAssociation.getTo()), JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo())));
        JSourceCode sc = breakMethod.getSourceCode();
        if (modelAssociation.isOneMultiplicity()) {
            sc.add("if ( this." + modelAssociation.getName() + " != " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " isn't associated.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add("this." + modelAssociation.getName() + " = null;");
        } else {
            sc.add("if ( ! get" + this.capitalise(modelAssociation.getName()) + "().contains( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " ) )");
            sc.add("{");
            sc.indent();
            sc.add("throw new IllegalStateException( \"" + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " isn't associated.\" );");
            sc.unindent();
            sc.add("}");
            sc.add("");
            sc.add("get" + this.capitalise(modelAssociation.getName()) + "().remove( " + JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo()) + " );");
        }
        jClass.addMethod(breakMethod);
    }

    private void createAdder(ModelAssociation modelAssociation, JClass jClass) throws ModelloException {
        JClass addType;
        String parameterName;
        String fieldName = modelAssociation.getName();
        JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
        String implementationParameterName = parameterName = JavaModelloGenerator.uncapitalise((String)modelAssociation.getTo());
        boolean bidirectionalAssociation = this.isBidirectionalAssociation(modelAssociation);
        if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName())) {
            addType = new JClass(javaAssociationMetadata.getInterfaceName());
            implementationParameterName = "( (" + modelAssociation.getTo() + ") " + parameterName + " )";
        } else {
            addType = modelAssociation.getToClass() != null ? new JClass(modelAssociation.getToClass().getName()) : new JClass("String");
        }
        if (modelAssociation.getType().equals("java.util.Properties") || modelAssociation.getType().equals("java.util.Map")) {
            JMethod adder = new JMethod("add" + this.capitalise(JavaModelloGenerator.singular((String)fieldName)));
            if (modelAssociation.getType().equals("java.util.Map")) {
                adder.addParameter(new JParameter(new JClass("Object"), "key"));
            } else {
                adder.addParameter(new JParameter(new JClass("String"), "key"));
            }
            adder.addParameter(new JParameter(new JClass(modelAssociation.getTo()), "value"));
            adder.getSourceCode().add("get" + this.capitalise(fieldName) + "().put( key, value );");
            jClass.addMethod(adder);
        } else {
            JMethod adder = new JMethod("add" + JavaModelloGenerator.singular((String)this.capitalise(fieldName)));
            adder.addParameter(new JParameter(addType, parameterName));
            this.createClassCastAssertion(adder.getSourceCode(), modelAssociation, "add");
            adder.getSourceCode().add("get" + this.capitalise(fieldName) + "().add( " + implementationParameterName + " );");
            if (bidirectionalAssociation && javaAssociationMetadata.isBidi()) {
                adder.getSourceCode().add(implementationParameterName + ".create" + modelAssociation.getModelClass().getName() + "Association( this );");
            }
            jClass.addMethod(adder);
            JMethod remover = new JMethod("remove" + JavaModelloGenerator.singular((String)this.capitalise(fieldName)));
            remover.addParameter(new JParameter(addType, parameterName));
            this.createClassCastAssertion(remover.getSourceCode(), modelAssociation, "remove");
            if (bidirectionalAssociation && javaAssociationMetadata.isBidi()) {
                remover.getSourceCode().add(parameterName + ".break" + modelAssociation.getModelClass().getName() + "Association( this );");
            }
            remover.getSourceCode().add("get" + this.capitalise(fieldName) + "().remove( " + implementationParameterName + " );");
            jClass.addMethod(remover);
        }
    }

    private boolean isBidirectionalAssociation(ModelAssociation association) {
        Model model = association.getModelClass().getModel();
        if (!this.isClassInModel(association.getTo(), model)) {
            return false;
        }
        ModelClass toClass = association.getToClass();
        Iterator j = toClass.getFields(this.getGeneratedVersion()).iterator();
        while (j.hasNext()) {
            ModelAssociation modelAssociation;
            ModelField modelField = (ModelField)j.next();
            if (!(modelField instanceof ModelAssociation) || !this.isClassInModel((modelAssociation = (ModelAssociation)modelField).getTo(), model)) continue;
            ModelClass totoClass = modelAssociation.getToClass();
            if (!association.getModelClass().equals((Object)totoClass)) continue;
            return true;
        }
        return false;
    }

    private JType getDesiredType(ModelField modelField, boolean useTo) throws ModelloException {
        JField field = this.createField(modelField);
        JType type = field.getType();
        if (modelField instanceof ModelAssociation) {
            ModelAssociation modelAssociation = (ModelAssociation)modelField;
            JavaAssociationMetadata javaAssociationMetadata = (JavaAssociationMetadata)modelAssociation.getAssociationMetadata(JavaAssociationMetadata.ID);
            if (StringUtils.isNotEmpty((String)javaAssociationMetadata.getInterfaceName()) && !modelAssociation.isManyMultiplicity()) {
                type = new JClass(javaAssociationMetadata.getInterfaceName());
            } else if (modelAssociation.isManyMultiplicity() && modelAssociation.isGenericType()) {
                JType componentType = this.getComponentType(modelAssociation, javaAssociationMetadata);
                type = new JCollectionType(modelAssociation.getType(), componentType, this.useJava5);
            } else if (useTo) {
                type = new JClass(modelAssociation.getTo());
            }
        }
        return type;
    }
}

