/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.java.javasource;

import java.io.IOException;
import java.io.Writer;

public class JSourceWriter
extends Writer {
    public static final char DEFAULT_CHAR = ' ';
    public static final short DEFAULT_SIZE = 4;
    private String lineSeparator = System.getProperty("line.separator");
    private boolean addIndentation = true;
    private boolean autoflush = false;
    private short tabSize = (short)4;
    private char[] tab;
    private char tabChar = (char)32;
    private short tabLevel = 0;
    private Writer out = null;

    public JSourceWriter(Writer out) {
        this(out, 4, ' ', false);
    }

    public JSourceWriter(Writer out, boolean autoflush) {
        this(out, 4, ' ', autoflush);
    }

    public JSourceWriter(Writer out, short tabSize, boolean autoflush) {
        this(out, tabSize, ' ', autoflush);
    }

    public JSourceWriter(Writer out, short tabSize, char tabChar, boolean autoflush) {
        this.out = out;
        this.autoflush = autoflush;
        this.tabChar = tabChar;
        this.tabSize = tabSize;
        this.createTab();
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void indent() {
        this.tabLevel = (short)(this.tabLevel + 1);
    }

    public boolean isNewline() {
        return this.addIndentation;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    public void unindent() {
        if (this.tabLevel > 0) {
            this.tabLevel = (short)(this.tabLevel - 1);
        }
    }

    public void write(float f) {
        this.write(String.valueOf(f));
    }

    public void write(long l) {
        this.write(String.valueOf(l));
    }

    public void write(double d) {
        this.write(String.valueOf(d));
    }

    public void write(Object obj) {
        this.write(obj.toString());
    }

    public void write(boolean b) {
        this.write(String.valueOf(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln() {
        Object object = this.lock;
        synchronized (object) {
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(float f) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(f));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(long l) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(l));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(int i) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(i));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(double d) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(d));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(obj.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(String string) {
        Object object = this.lock;
        synchronized (object) {
            if (string.length() > 0) {
                this.ensureIndent();
                try {
                    this.out.write(string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(char[] chars) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(chars);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(boolean b) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(String.valueOf(b));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeln(char c) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.linefeed();
            this.addIndentation = true;
        }
    }

    public void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(s, off, len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(buf);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        Object object = this.lock;
        synchronized (object) {
            this.ensureIndent();
            try {
                this.out.write(buf, off, len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.autoflush) {
                this.flush();
            }
        }
    }

    protected short getIndentLevel() {
        return this.tabLevel;
    }

    protected short getIndentSize() {
        return (short)(this.tabLevel * this.tabSize);
    }

    protected char getIndentChar() {
        return this.tabChar;
    }

    protected void writeIndent() {
        try {
            for (int i = 0; i < this.tabLevel; ++i) {
                this.out.write(this.tab);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void ensureIndent() {
        if (this.addIndentation) {
            this.writeIndent();
            this.addIndentation = false;
        }
    }

    private void linefeed() {
        try {
            this.out.write(this.lineSeparator);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void createTab() {
        this.tab = new char[this.tabSize];
        for (int i = 0; i < this.tabSize; ++i) {
            this.tab[i] = this.tabChar;
        }
    }
}

