/*
 * Sonar Java
 * Copyright (C) 2012 SonarSource
 * dev@sonar.codehaus.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;

import java.util.List;

public final class CheckList {

  public static final String REPOSITORY_KEY = "squid";

  private CheckList() {
  }

  public static List<Class> getChecks() {
    return ImmutableList.<Class> of(
        // AST
        ParsingErrorCheck.class,
        BreakCheck.class,
        ContinueCheck.class,
        MethodComplexityCheck.class,
        ClassComplexityCheck.class,
        UndocumentedApiCheck.class,
        NoSonarCheck.class,
        CommentedOutCodeLineCheck.class,
        EmptyFileCheck.class,
        XPathCheck.class,
        // Bytecode
        CycleBetweenPackagesCheck.class,
        DITCheck.class,
        LCOM4Check.class,
        ArchitectureCheck.class,
        CallToDeprecatedMethodCheck.class,
        CallToFileDeleteOnExitMethodCheck.class,
        UnusedProtectedMethodCheck.class,
        UnusedPrivateMethodCheck.class);
  }

}
