/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Cardinality;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.PatternUtils;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="ArchitecturalConstraint", cardinality=Cardinality.MULTIPLE, priority=Priority.MAJOR)
public class ArchitectureCheck
extends BytecodeVisitor {
    @RuleProperty
    private String fromClasses = "";
    @RuleProperty
    private String toClasses = "";
    private WildcardPattern[] fromPatterns;
    private WildcardPattern[] toPatterns;
    private AsmClass asmClass;
    private Map<String, CheckMessage> internalNames;

    public String getFromClasses() {
        return this.fromClasses;
    }

    public void setFromClasses(String patterns) {
        this.fromClasses = patterns;
    }

    public String getToClasses() {
        return this.toClasses;
    }

    public void setToClasses(String patterns) {
        this.toClasses = patterns;
    }

    public void visitClass(AsmClass asmClass) {
        String nameAsmClass = asmClass.getInternalName();
        if (WildcardPattern.match((WildcardPattern[])this.getFromPatterns(), (String)nameAsmClass)) {
            this.asmClass = asmClass;
            this.internalNames = Maps.newHashMap();
        } else {
            this.asmClass = null;
        }
    }

    public void leaveClass(AsmClass asmClass) {
        if (this.asmClass != null) {
            for (CheckMessage message : this.internalNames.values()) {
                SourceFile sourceFile = this.getSourceFile(asmClass);
                sourceFile.log(message);
            }
        }
    }

    public void visitEdge(AsmEdge edge) {
        if (this.asmClass != null && edge != null) {
            String internalNameTargetClass = edge.getTargetAsmClass().getInternalName();
            if (!this.internalNames.containsKey(internalNameTargetClass)) {
                if (WildcardPattern.match((WildcardPattern[])this.getToPatterns(), (String)internalNameTargetClass)) {
                    int sourceLineNumber = this.getSourceLineNumber(edge);
                    this.logMessage(this.asmClass.getInternalName(), internalNameTargetClass, sourceLineNumber);
                }
            } else {
                int sourceLineNumber = this.getSourceLineNumber(edge);
                if (this.internalNames.get(internalNameTargetClass).getLine() == 0 && sourceLineNumber != 0) {
                    this.logMessage(this.asmClass.getInternalName(), internalNameTargetClass, sourceLineNumber);
                }
            }
        }
    }

    private int getSourceLineNumber(AsmEdge edge) {
        SourceMethod sourceMethod;
        if (edge.getSourceLineNumber() == 0 && edge.getFrom() instanceof AsmMethod && (sourceMethod = this.getSourceMethod((AsmMethod)edge.getFrom())) != null) {
            return sourceMethod.getStartAtLine();
        }
        return edge.getSourceLineNumber();
    }

    private void logMessage(String fromClass, String toClass, int sourceLineNumber) {
        CheckMessage message = new CheckMessage((Object)this, fromClass + " must not use " + toClass, new Object[0]);
        message.setLine(sourceLineNumber);
        this.internalNames.put(toClass, message);
    }

    private WildcardPattern[] getFromPatterns() {
        if (this.fromPatterns == null) {
            this.fromPatterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.fromClasses, (String)"**"));
        }
        return this.fromPatterns;
    }

    private WildcardPattern[] getToPatterns() {
        if (this.toPatterns == null) {
            this.toPatterns = PatternUtils.createPatterns(this.toClasses);
        }
        return this.toPatterns;
    }
}

