/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.JavaAstCheck;
import org.sonar.java.checks.JavaFootprint;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.recognizer.LanguageFootprint;

@Rule(key="CommentedOutCodeLine", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class CommentedOutCodeLineCheck
extends JavaAstCheck
implements AstAndTokenVisitor {
    private static final double THRESHOLD = 0.9;
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaFootprint());
    private List<Token> comments;
    private static final String START_JSNI = "/*-{";
    private static final String END_JSNI = "}-*/";

    public void visitFile(AstNode astNode) {
        this.comments = Lists.newArrayList();
    }

    public void visitToken(Token token) {
        for (Trivia trivia : token.getTrivia()) {
            Token comment;
            if (!trivia.isComment() || CommentedOutCodeLineCheck.isHeader(comment = trivia.getToken()) || this.isJavadoc(comment.getOriginalValue()) || this.isJSNI(comment.getOriginalValue())) continue;
            this.comments.add(trivia.getToken());
        }
    }

    private static boolean isHeader(Token comment) {
        return comment.getLine() == 1;
    }

    public void leaveFile(AstNode astNode) {
        ArrayList commentedOutCodeLines = Lists.newArrayList();
        block0: for (Token comment : this.comments) {
            String[] lines = this.getContext().getCommentAnalyser().getContents(comment.getOriginalValue()).split("(\r)?\n|\r", -1);
            for (int i = 0; i < lines.length; ++i) {
                if (!this.codeRecognizer.isLineOfCode(lines[i])) continue;
                for (int j = i; j < lines.length; ++j) {
                    commentedOutCodeLines.add(comment.getLine() + j);
                }
                continue block0;
            }
        }
        Collections.sort(commentedOutCodeLines);
        int prev = Integer.MIN_VALUE;
        for (int i = 0; i < commentedOutCodeLines.size(); ++i) {
            int current = (Integer)commentedOutCodeLines.get(i);
            if (prev + 1 < current) {
                this.getContext().createLineViolation((CodeCheck)this, "This block of commented-out lines of code should be removed.", current, new Object[0]);
            }
            prev = current;
        }
        this.comments = null;
    }

    private boolean isJavadoc(String comment) {
        return StringUtils.startsWith((String)comment, (String)"/**");
    }

    private boolean isJSNI(String comment) {
        return StringUtils.startsWith((String)comment, (String)START_JSNI) && StringUtils.endsWith((String)comment, (String)END_JSNI);
    }
}

