/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

@Rule(key="MaximumLackOfCohesionOfMethods", priority=Priority.MAJOR)
public class LCOM4Check
extends BytecodeVisitor {
    public static final int DEFAULT_MAX = 1;
    @RuleProperty(defaultValue="1")
    private Integer max = 1;

    public void leaveClass(AsmClass asmClass) {
        SourceClass sourceClass = this.getSourceClass(asmClass);
        int lcom4 = sourceClass.getInt(Metric.LCOM4);
        if (lcom4 > this.max) {
            CheckMessage message = new CheckMessage((Object)this, "This class has an LCOM4 of " + lcom4 + ", which is greater than " + this.max + " authorized.", new Object[0]);
            message.setLine(sourceClass.getStartAtLine());
            message.setCost((double)(lcom4 - this.max));
            ((SourceFile)sourceClass.getParent(SourceFile.class)).log(message);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

