/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.checks.ChecksHelper;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.visitors.JavaAstCheck;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.MetricDef;

@Rule(key="MethodCyclomaticComplexity", priority=Priority.MAJOR)
public class MethodComplexityCheck
extends JavaAstCheck {
    private static final int DEFAULT_MAX = 10;
    @RuleProperty(defaultValue="10")
    private int max = 10;

    public void init() {
        MethodHelper.subscribe((SquidAstVisitor)this);
    }

    public void leaveNode(AstNode node) {
        SourceMethod sourceMethod = (SourceMethod)this.getContext().peekSourceCode();
        int complexity = ChecksHelper.getRecursiveMeasureInt((SourceCode)sourceMethod, (MetricDef)JavaMetric.COMPLEXITY);
        if (complexity > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "The Cyclomatic Complexity of this method is {0,number,integer} which is greater than {1,number,integer} authorized.", node, new Object[]{complexity, this.max});
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

