/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.JavaAstCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;

@Rule(key="NoSonar", priority=Priority.INFO)
public class NoSonarCheck
extends JavaAstCheck
implements AstAndTokenVisitor {
    public void visitToken(Token token) {
        SourceFile sourceFile = this.getSourceFile();
        for (Trivia trivia : token.getTrivia()) {
            if (!trivia.isComment()) continue;
            String[] commentLines = this.getContext().getCommentAnalyser().getContents(trivia.getToken().getOriginalValue()).split("(\r)?\n|\r", -1);
            int line = trivia.getToken().getLine();
            for (String commentLine : commentLines) {
                if (commentLine.contains("NOSONAR")) {
                    CheckMessage checkMessage = new CheckMessage((CodeCheck)this, "Is //NOSONAR used to exclude false-positive or to hide real quality flaw ?", new Object[0]);
                    checkMessage.setBypassExclusion(true);
                    checkMessage.setLine(line);
                    sourceFile.log(checkMessage);
                }
                ++line;
            }
        }
    }

    private SourceFile getSourceFile() {
        if (this.getContext().peekSourceCode() instanceof SourceFile) {
            return (SourceFile)this.getContext().peekSourceCode();
        }
        return (SourceFile)this.getContext().peekSourceCode().getParent(SourceFile.class);
    }
}

