/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.checks.SerializableContract;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="UnusedPrivateMethod", priority=Priority.MAJOR)
public class UnusedPrivateMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (!asmMethod.isUsed() && asmMethod.isPrivate() && !asmMethod.isDefaultConstructor() && !SerializableContract.methodMatch(asmMethod)) {
            CheckMessage message = new CheckMessage((Object)this, "Private method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }
}

