/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00118", priority=Priority.MAJOR)
public class BadAbstractClassName_S00118_Check
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FORMAT = "^Abstract[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^Abstract[A-Z][a-zA-Z0-9]*$")
    public String format = "^Abstract[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION});
        this.pattern = Pattern.compile(this.format, 32);
    }

    public void visitNode(AstNode astNode) {
        String name = astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenValue();
        if (this.pattern.matcher(name).matches()) {
            if (!this.isAbstract(astNode)) {
                this.getContext().createLineViolation((CodeCheck)this, "Make this class abstract or rename it, since it matches the regular expression '" + this.format + "'.", astNode, new Object[0]);
            }
        } else if (this.isAbstract(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this abstract class name to match the regular expression '" + this.format + "'.", astNode, new Object[0]);
        }
    }

    private boolean isAbstract(AstNode astNode) {
        for (AstNode modifier = astNode.getPreviousAstNode(); modifier != null && modifier.is(new AstNodeType[]{JavaGrammar.MODIFIER}); modifier = modifier.getPreviousAstNode()) {
            if (!modifier.getFirstChild().is(new AstNodeType[]{JavaKeyword.ABSTRACT})) continue;
            return true;
        }
        return false;
    }
}

