/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00115", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadConstantName_S00115_Check
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FORMAT = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    @RuleProperty(key="format", defaultValue="^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$")
    public String format = "^[A-Z][A-Z0-9]*(_[A-Z0-9]+)*$";
    private Pattern pattern = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.FIELD_DECLARATION, JavaGrammar.ENUM_CONSTANT, JavaGrammar.CONSTANT_DECLARATOR_REST});
        this.pattern = Pattern.compile(this.format, 32);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.CONSTANT_DECLARATOR_REST})) {
            this.check(astNode.getPreviousAstNode());
        } else if (astNode.is(new AstNodeType[]{JavaGrammar.ENUM_CONSTANT})) {
            this.check(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        } else if (this.isConstant(astNode)) {
            for (AstNode variableDeclarator : astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS}).getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                AstNode identifierNode = variableDeclarator.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER});
                if (identifierNode.getTokenValue().equals("serialVersionUID")) continue;
                this.check(identifierNode);
            }
        }
    }

    private void check(AstNode identifier) {
        Preconditions.checkArgument((boolean)identifier.is(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        String name = identifier.getTokenValue();
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this constant name to match the regular expression '" + this.format + "'.", identifier, new Object[0]);
        }
    }

    private boolean isConstant(AstNode astNode) {
        boolean isStatic = false;
        boolean isFinal = false;
        for (AstNode modifier : astNode.getFirstAncestor((AstNodeType)JavaGrammar.CLASS_BODY_DECLARATION).getChildren(new AstNodeType[]{JavaGrammar.MODIFIER})) {
            if (modifier.getFirstChild().is(new AstNodeType[]{JavaKeyword.STATIC})) {
                isStatic = true;
                continue;
            }
            if (!modifier.getFirstChild().is(new AstNodeType[]{JavaKeyword.FINAL})) continue;
            isFinal = true;
        }
        return isStatic && isFinal;
    }
}

