/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00114", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadInterfaceName_S00114_Check
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FORMAT = "^[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    public String format = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.INTERFACE_DECLARATION});
        this.pattern = Pattern.compile(this.format, 32);
    }

    public void visitNode(AstNode astNode) {
        String name = astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}).getTokenValue();
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this interface name to match the regular expression '" + this.format + "'.", astNode, new Object[0]);
        }
    }
}

