/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.regex.Pattern;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00117", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadLocalVariableName_S00117_Check
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT, JavaGrammar.VARIABLE_DECLARATOR_ID, JavaGrammar.FOR_INIT});
        this.pattern = Pattern.compile(this.format, 32);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID})) {
            this.check(astNode.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
        } else {
            AstNode variableDeclarators = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATORS});
            if (variableDeclarators != null) {
                for (AstNode variableDeclarator : variableDeclarators.getChildren(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR})) {
                    this.check(variableDeclarator.getFirstChild(new AstNodeType[]{JavaTokenType.IDENTIFIER}));
                }
            }
        }
    }

    private void check(AstNode identifier) {
        String name = identifier.getTokenValue();
        if (!this.pattern.matcher(name).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this local variable name to match the regular expression '" + this.format + "'.", identifier, new Object[0]);
        }
    }
}

