/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;

@Rule(key="CallToFileDeleteOnExitMethod", priority=Priority.MAJOR)
public class CallToFileDeleteOnExitMethodCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitEdge(AsmEdge edge) {
        AsmMethod targetMethod;
        AsmClass targetClass;
        if (edge.getTo() instanceof AsmMethod && "java/io/File".equals((targetClass = (targetMethod = (AsmMethod)edge.getTo()).getParent()).getInternalName()) && "deleteOnExit()V".equals(targetMethod.getKey())) {
            SourceFile sourceFile = this.getSourceFile(this.asmClass);
            CheckMessage message = new CheckMessage((Object)this, "Do not use method 'File#deleteOnExit()'.", new Object[0]);
            message.setLine(edge.getSourceLineNumber());
            sourceFile.log(message);
        }
    }
}

