/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitors.JavaAstCheck;
import org.sonar.squid.api.CodeCheck;

@Rule(key="EmptyFile", priority=Priority.MAJOR)
public final class EmptyFileCheck
extends JavaAstCheck
implements AstAndTokenVisitor {
    private boolean empty;

    public void visitFile(AstNode astNode) {
        this.empty = true;
    }

    public void visitToken(Token token) {
        if (token.getType() != GenericTokenType.EOF) {
            this.empty = false;
        }
    }

    public void leaveFile(AstNode astNode) {
        if (this.empty) {
            this.getContext().createFileViolation((CodeCheck)this, "This Java file is empty", new Object[0]);
        }
    }
}

