/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableSet;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.util.Set;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00112", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class RawException_S00112_Check
extends SquidCheck<LexerlessGrammar> {
    private static final Set<String> RAW_EXCEPTIONS = ImmutableSet.of((Object)"Throwable", (Object)"Error", (Object)"Exception", (Object)"RuntimeException");

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.THROW_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode primary = astNode.getFirstChild(new AstNodeType[]{JavaGrammar.EXPRESSION}).getFirstChild(new AstNodeType[]{JavaGrammar.PRIMARY});
        if (primary == null || primary.getFirstChild().isNot(new AstNodeType[]{JavaKeyword.NEW})) {
            return;
        }
        AstNode createdName = primary.getFirstDescendant(new AstNodeType[]{JavaGrammar.CREATED_NAME});
        if (createdName == null) {
            return;
        }
        String name = RawException_S00112_Check.tokensToString(createdName);
        if (RAW_EXCEPTIONS.contains(name)) {
            this.getContext().createLineViolation((CodeCheck)this, "Define and throw a dedicated exception instead of using a generic one.", astNode, new Object[0]);
        }
    }

    private static String tokensToString(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (Token token : astNode.getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

