/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.SquidCheck;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00103", priority=Priority.MINOR)
public class TooLongLine_S00103_Check
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    @RuleProperty(key="maximumLineLength", defaultValue="80")
    public int maximumLineLength = 80;
    private Charset charset;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(AstNode astNode) {
        List lines;
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= this.maximumLineLength) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Split this {0} characters long line (which is greater than {1} authorized).", i + 1, new Object[]{line.length(), this.maximumLineLength});
        }
    }
}

