/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.squid.checks.ChecksHelper;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00104", priority=Priority.MAJOR)
public class TooManyLinesOfCodeInFile_S00104_Check
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAXIMUM = 1000;
    @RuleProperty(key="maximumFileLocThreshold", defaultValue="1000")
    public int maximum = 1000;

    public void leaveFile(AstNode astNode) {
        int linesOfCode = ChecksHelper.getRecursiveMeasureInt((SourceCode)this.getContext().peekSourceCode(), (MetricDef)JavaMetric.LINES_OF_CODE);
        if (linesOfCode > this.maximum) {
            this.getContext().createFileViolation((CodeCheck)this, "This file has {0} lines of code, which is greater than {1} authorized. Split it into smaller files.", new Object[]{linesOfCode, this.maximum});
        }
    }
}

