/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S00107", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class TooManyParameters_S00107_Check
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAXIMUM = 7;
    @RuleProperty(key="maximumMethodParameters", defaultValue="7")
    public int maximum = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.FORMAL_PARAMETERS});
    }

    public void visitNode(AstNode astNode) {
        int count = astNode.getDescendants(new AstNodeType[]{JavaGrammar.VARIABLE_DECLARATOR_ID}).size();
        if (count > this.maximum) {
            this.getContext().createLineViolation((CodeCheck)this, "Method has {0} parameters, which is greater than {1} authorized.", astNode, new Object[]{count, this.maximum});
        }
    }
}

