/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.visitors.JavaAstCheck;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.PublicApiVisitor;
import org.sonar.java.checks.PatternUtils;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;

@Rule(key="UndocumentedApi", priority=Priority.MAJOR)
public class UndocumentedApiCheck
extends JavaAstCheck {
    @RuleProperty
    private String forClasses = "";
    private WildcardPattern[] patterns;

    public void init() {
        PublicApiVisitor.subscribe((JavaAstVisitor)this);
    }

    public void visitNode(AstNode astNode) {
        SourceCode currentResource = this.getContext().peekSourceCode();
        if (!WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)this.peekSourceClass().getKey())) {
            return;
        }
        if (currentResource instanceof SourceMethod && ((SourceMethod)currentResource).isAccessor()) {
            return;
        }
        if (PublicApiVisitor.isPublicApi((AstNode)astNode) && !PublicApiVisitor.isDocumentedApi((AstNode)astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Avoid undocumented API.", astNode, new Object[0]);
        }
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.forClasses, (String)"**"));
        }
        return this.patterns;
    }
}

