/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.squid.api.CodeCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1188", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AnonymousClassesTooBigCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT_MAX = 20;
    @RuleProperty(defaultValue="20")
    public int max = 20;

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_CREATOR_REST});
    }

    public void visitNode(AstNode node) {
        int lines;
        AstNode classBody = node.getFirstChild(new AstNodeType[]{JavaGrammar.CLASS_BODY});
        if (classBody != null && (lines = AnonymousClassesTooBigCheck.getNumberOfLines(classBody)) > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "Reduce this anonymous class number of lines from " + lines + " to at most " + this.max + ", or make it a named class.", node, new Object[0]);
        }
    }

    private static int getNumberOfLines(AstNode node) {
        return node.getLastChild().getTokenLine() - node.getTokenLine() + 1;
    }
}

