/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import javax.annotation.Nullable;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="AssignmentInSubExpressionCheck", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class AssignmentInSubExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "AssignmentInSubExpressionCheck";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"AssignmentInSubExpressionCheck");
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expressionTree = tree.expression();
        while (expressionTree instanceof AssignmentExpressionTree) {
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)expressionTree;
            this.scan((Tree)assignmentExpressionTree.variable());
            expressionTree = assignmentExpressionTree.expression();
        }
        this.scan((Tree)expressionTree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (AssignmentInSubExpressionCheck.isRelationalExpression((Tree)tree)) {
            this.visitInnerExpression(tree.leftOperand());
            this.visitInnerExpression(tree.rightOperand());
        } else {
            super.visitBinaryExpression(tree);
        }
    }

    private void visitInnerExpression(ExpressionTree tree) {
        AssignmentExpressionTree assignmentExpressionTree = AssignmentInSubExpressionCheck.getInnerAssignmentExpression(tree);
        if (assignmentExpressionTree != null) {
            super.visitAssignmentExpression(assignmentExpressionTree);
        } else {
            this.scan((Tree)tree);
        }
    }

    @Nullable
    private static AssignmentExpressionTree getInnerAssignmentExpression(ExpressionTree tree) {
        ParenthesizedTree parenthesizedTree;
        if (tree.is(Tree.Kind.PARENTHESIZED_EXPRESSION) && (parenthesizedTree = (ParenthesizedTree)tree).expression().is(Tree.Kind.ASSIGNMENT)) {
            return (AssignmentExpressionTree)parenthesizedTree.expression();
        }
        return null;
    }

    private static boolean isRelationalExpression(Tree tree) {
        return tree.is(Tree.Kind.EQUAL_TO) || tree.is(Tree.Kind.NOT_EQUAL_TO) || tree.is(Tree.Kind.LESS_THAN) || tree.is(Tree.Kind.LESS_THAN_OR_EQUAL_TO) || tree.is(Tree.Kind.GREATER_THAN) || tree.is(Tree.Kind.GREATER_THAN_OR_EQUAL_TO);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        super.visitAssignmentExpression(tree);
        this.context.addIssue((Tree)tree, this.ruleKey, "Extract the assignment out of this expression.");
    }
}

