/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00118", priority=Priority.MAJOR)
public class BadAbstractClassName_S00118_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00118";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00118");
    private static final String DEFAULT_FORMAT = "^Abstract[A-Z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^Abstract[A-Z][a-zA-Z0-9]*$")
    public String format = "^Abstract[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        if (tree.is(Tree.Kind.CLASS) && tree.simpleName() != null) {
            if (this.pattern.matcher(tree.simpleName()).matches()) {
                if (!this.isAbstract(tree)) {
                    this.context.addIssue((Tree)tree, this.ruleKey, "Make this class abstract or rename it, since it matches the regular expression '" + this.format + "'.");
                }
            } else if (this.isAbstract(tree)) {
                this.context.addIssue((Tree)tree, this.ruleKey, "Rename this abstract class name to match the regular expression '" + this.format + "'.");
            }
        }
        super.visitClass(tree);
    }

    private boolean isAbstract(ClassTree tree) {
        for (Modifier modifier : tree.modifiers().modifiers()) {
            if (modifier != Modifier.ABSTRACT) continue;
            return true;
        }
        return false;
    }
}

