/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.regex.Pattern;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;

@Rule(key="S00100", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class BadMethodName_S00100_Check
extends BaseTreeVisitor
implements JavaFileScanner {
    public static final String RULE_KEY = "S00100";
    private final RuleKey ruleKey = RuleKey.of((String)"squid", (String)"S00100");
    private static final String DEFAULT_FORMAT = "^[a-z][a-zA-Z0-9]*$";
    @RuleProperty(key="format", defaultValue="^[a-z][a-zA-Z0-9]*$")
    public String format = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format, 32);
        }
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitMethod(MethodTree tree) {
        if (!BadMethodName_S00100_Check.isConstructor(tree) && !this.pattern.matcher(tree.simpleName()).matches()) {
            this.context.addIssue((Tree)tree, this.ruleKey, "Rename this method name to match the regular expression '" + this.format + "'.");
        }
        super.visitMethod(tree);
    }

    private static boolean isConstructor(MethodTree tree) {
        return tree.returnType() == null;
    }
}

